/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.selection.SingleSelectionModel;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;

public class ComboBoxSelectionModel<T>
extends SingleSelectionModel<T> {
    public ComboBoxSelectionModel(ObservableList<T> items) {
        super(items);
    }

    public ComboBoxSelectionModel(ObjectProperty<ObservableList<T>> items) {
        super(items);
    }

    public void selectFirst() {
        if (this.itemsEmpty()) {
            return;
        }
        this.selectIndex(0);
    }

    public void selectNext() {
        int index = this.getSelectedIndex() + 1;
        if (index < this.itemsSize()) {
            this.selectIndex(index);
        }
    }

    public void selectPrevious() {
        int index = this.getSelectedIndex() - 1;
        if (index >= 0 && !this.itemsEmpty()) {
            this.selectIndex(index);
        }
    }

    public void selectLast() {
        if (this.itemsEmpty()) {
            return;
        }
        int index = this.itemsSize() - 1;
        this.selectIndex(index);
    }

    private int itemsSize() {
        return ((ObservableList)this.items.get()).size();
    }

    private boolean itemsEmpty() {
        return ((ObservableList)this.items.get()).isEmpty();
    }
}

