/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.beans.properties.synced.SynchronizedIntegerProperty;
import io.github.palexdev.materialfx.beans.properties.synced.SynchronizedObjectProperty;
import io.github.palexdev.materialfx.bindings.BiBindingManager;
import io.github.palexdev.materialfx.bindings.BindingManager;
import io.github.palexdev.materialfx.selection.base.AbstractSingleSelectionModel;
import io.github.palexdev.materialfx.utils.others.TriConsumer;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;

public class SingleSelectionManager<T> {
    private final AbstractSingleSelectionModel<T> selectionModel;
    private final SynchronizedIntegerProperty selectedIndex = new SynchronizedIntegerProperty(-1);
    private final SynchronizedObjectProperty<T> selectedItem = new SynchronizedObjectProperty<Object>(null);
    private boolean clearing;

    public SingleSelectionManager(AbstractSingleSelectionModel<T> selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void clearSelection() {
        if (this.isBound()) {
            throw new IllegalStateException("Cannot clear the selection as this selection model is bound to some other property");
        }
        this.clearing = true;
        this.selectedIndex.setAndWait(-1, (ObservableValue<?>)this.selectedItem);
        this.selectedItem.set(null);
        this.selectedIndex.awake();
        this.clearing = false;
    }

    public void updateSelection(int index) {
        if (this.isBound()) {
            throw new IllegalStateException("Cannot set the selected index as this selection model is bound to some other property");
        }
        if (this.clearing) {
            this.clearSelection();
            return;
        }
        Object item = this.selectionModel.getUnmodifiableItems().get(index);
        this.selectedIndex.setAndWait(index, (ObservableValue<?>)this.selectedItem);
        this.selectedItem.set(item);
        if (this.selectedIndex.isWaiting()) {
            this.selectedIndex.awake();
        }
    }

    public void updateSelection(T item) {
        if (this.isBound()) {
            throw new IllegalStateException("Cannot set the selected item as this selection model is bound to some other property");
        }
        if (this.clearing) {
            this.clearSelection();
            return;
        }
        int index = this.selectionModel.getUnmodifiableItems().indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("The given item is not present is this selection model's list");
        }
        this.selectedItem.setAndWait(item, (ObservableValue<?>)this.selectedIndex);
        this.selectedIndex.set(index);
        if (this.selectedItem.isWaiting()) {
            this.selectedItem.awake();
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex.get();
    }

    public SynchronizedIntegerProperty selectedIndexProperty() {
        return this.selectedIndex;
    }

    public T getSelectedItem() {
        return (T)this.selectedItem.get();
    }

    public SynchronizedObjectProperty<T> selectedItemProperty() {
        return this.selectedItem;
    }

    public void setClearing(boolean clearing) {
        this.clearing = clearing;
    }

    public void bindIndex(ObservableValue<? extends Number> source, Function<Integer, T> indexConverter) {
        if (this.selectedIndex.isBound()) {
            this.selectedIndex.unbind();
        }
        BindingManager.instance().bind(this.selectedIndex).with((oldValue, newValue) -> {
            Object item = indexConverter.apply(newValue.intValue());
            this.selectedIndex.setAndWait(newValue.intValue(), (ObservableValue<?>)this.selectedItem);
            this.selectedItem.set(item);
        }).to(source).create();
    }

    public void bindIndexBidirectional(Property<Number> other, Function<Integer, T> indexConverter, TriConsumer<Boolean, Integer, Property<Number>> updateOther) {
        if (this.selectedIndex.isBound()) {
            this.selectedIndex.unbind();
        }
        BiBindingManager.instance().bindBidirectional(this.selectedIndex).with((oldValue, newValue) -> {
            if (newValue.intValue() == -1) {
                this.clearSelection();
                return;
            }
            if (newValue.intValue() == this.selectedIndex.getValue().intValue()) {
                return;
            }
            Object item = indexConverter.apply(newValue.intValue());
            this.selectedIndex.setAndWait(newValue.intValue(), (ObservableValue<?>)this.selectedItem);
            this.selectedItem.set(item);
        }).to((ObservableValue<Number>)other, (oldValue, newValue) -> updateOther.accept(this.clearing, newValue.intValue(), other)).create();
    }

    public void bindItem(ObservableValue<? extends T> source, Function<T, Integer> itemConverter) {
        if (this.selectedItem.isBound()) {
            this.selectedItem.unbind();
        }
        BindingManager.instance().bind(this.selectedItem).with((oldValue, newValue) -> {
            if (!this.selectionModel.getUnmodifiableItems().contains(newValue)) {
                throw new IllegalArgumentException("The given item is not present is this selection model's list");
            }
            int index = (Integer)itemConverter.apply(newValue);
            this.selectedItem.setAndWait(newValue, (ObservableValue<?>)this.selectedIndex);
            this.selectedIndex.set(index);
        }).to(source).create();
    }

    public void bindItemBidirectional(Property<T> other, Function<T, Integer> itemConverter, TriConsumer<Boolean, T, Property<T>> updateOther) {
        if (this.selectedItem.isBound()) {
            this.selectedItem.unbind();
        }
        BiBindingManager.instance().bindBidirectional(this.selectedItem).with((oldValue, newValue) -> {
            if (newValue == null) {
                this.clearSelection();
                return;
            }
            if (!this.selectionModel.getUnmodifiableItems().contains(newValue)) {
                throw new IllegalArgumentException("The given item is not present is this selection model's list");
            }
            int index = (Integer)itemConverter.apply(newValue);
            this.selectedItem.setAndWait(newValue, (ObservableValue<?>)this.selectedIndex);
            this.selectedIndex.set(index);
        }).to((ObservableValue<Object>)other, (oldValue, newValue) -> updateOther.accept(this.clearing, newValue, other)).create();
    }

    public void unbind() {
        if (this.selectedIndex.isBound()) {
            this.selectedIndex.unbind();
        }
        if (this.selectedItem.isBound()) {
            this.selectedItem.unbind();
        }
    }

    public void unbindIndexBidirectional(Property<Number> other) {
        this.selectedIndex.unbindBidirectional(other);
    }

    public void unbindItemBidirectional(Property<T> other) {
        this.selectedItem.unbindBidirectional(other);
    }

    public void unbindBidirectional() {
        this.selectedIndex.clearBidirectional();
        this.selectedItem.clearBidirectional();
    }

    public boolean isBound() {
        return this.selectedIndex.isBound() || this.selectedItem.isBound();
    }
}

