/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.selection.base.AbstractSingleSelectionModel;
import io.github.palexdev.materialfx.utils.others.TriConsumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;

public class SingleSelectionModel<T>
extends AbstractSingleSelectionModel<T> {
    public SingleSelectionModel(ObservableList<T> items) {
        super(items);
    }

    public SingleSelectionModel(ObjectProperty<ObservableList<T>> items) {
        super(items);
    }

    @Override
    public void clearSelection() {
        this.selectionManager.clearSelection();
    }

    @Override
    public void selectIndex(int index) {
        this.selectionManager.updateSelection(index);
    }

    @Override
    public void selectItem(T item) {
        this.selectionManager.updateSelection(item);
    }

    @Override
    public int getSelectedIndex() {
        return this.selectionManager.getSelectedIndex();
    }

    @Override
    public ReadOnlyIntegerProperty selectedIndexProperty() {
        return this.selectionManager.selectedIndexProperty().getReadOnlyProperty();
    }

    @Override
    public T getSelectedItem() {
        return this.selectionManager.getSelectedItem();
    }

    @Override
    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.selectionManager.selectedItemProperty().getReadOnlyProperty();
    }

    public void bindIndex(SingleSelectionModel<T> selectionModel) {
        this.selectionManager.bindIndex((ObservableValue<Number>)selectionModel.selectionManager.selectedIndexProperty(), arg_0 -> this.getItems().get(arg_0));
    }

    public void bindIndexBidirectional(SingleSelectionModel<T> selectionModel) {
        this.selectionManager.bindIndexBidirectional(selectionModel.selectionManager.selectedIndexProperty(), arg_0 -> this.getItems().get(arg_0), (clearing, i, other) -> {
            selectionModel.selectionManager.setClearing((boolean)clearing);
            selectionModel.selectionManager.updateSelection((int)i);
        });
    }

    public void bindItem(SingleSelectionModel<T> selectionModel) {
        this.selectionManager.bindItem(selectionModel.selectionManager.selectedItemProperty(), arg_0 -> this.getItems().indexOf(arg_0));
    }

    public void bindItemBidirectional(SingleSelectionModel<T> selectionModel) {
        this.selectionManager.bindItemBidirectional(selectionModel.selectionManager.selectedItemProperty(), arg_0 -> this.getItems().indexOf(arg_0), (clearing, item, other) -> {
            selectionModel.selectionManager.setClearing((boolean)clearing);
            selectionModel.selectionManager.updateSelection(item);
        });
    }

    public void bindIndex(ObservableValue<? extends Number> source, Function<Integer, T> indexConverter) {
        this.selectionManager.bindIndex(source, indexConverter);
    }

    public void bindIndexBidirectional(Property<Number> other, Function<Integer, T> indexConverter, TriConsumer<Boolean, Integer, Property<Number>> updateOther) {
        this.selectionManager.bindIndexBidirectional(other, indexConverter, updateOther);
    }

    public void bindItem(ObservableValue<? extends T> source, Function<T, Integer> itemConverter) {
        this.selectionManager.bindItem(source, itemConverter);
    }

    public void bindItemBidirectional(Property<T> other, Function<T, Integer> itemConverter, TriConsumer<Boolean, T, Property<T>> updateOther) {
        this.selectionManager.bindItemBidirectional(other, itemConverter, updateOther);
    }

    public void unbind() {
        this.selectionManager.unbind();
    }

    public void unbindIndexBidirectional(Property<Number> other) {
        this.selectionManager.unbindIndexBidirectional(other);
    }

    public void unbindItemBidirectional(Property<T> other) {
        this.selectionManager.unbindItemBidirectional(other);
    }

    public void unbindBidirectional() {
        this.selectionManager.unbindBidirectional();
    }

    public boolean isBound() {
        return this.selectionManager.isBound();
    }
}

