/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.BoundTextField;
import io.github.palexdev.materialfx.controls.MFXComboBox;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.selection.ComboBoxSelectionModel;
import io.github.palexdev.materialfx.selection.SingleSelectionModel;
import io.github.palexdev.materialfx.selection.base.ISingleSelectionModel;
import io.github.palexdev.materialfx.skins.MFXTextFieldSkin;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;

public class MFXComboBoxSkin<T>
extends MFXTextFieldSkin {
    protected final MFXPopup popup = this.createPopup();
    private EventHandler<MouseEvent> popupManager;
    protected SimpleVirtualFlow<T, Cell<T>> virtualFlow;

    public MFXComboBoxSkin(MFXComboBox<T> comboBox, BoundTextField boundField) {
        super(comboBox, boundField);
        this.setBehavior();
        T selectedItem = comboBox.getSelectedItem();
        if (selectedItem != null) {
            comboBox.setValue(selectedItem);
        }
    }

    protected void setBehavior() {
        this.comboBehavior();
        this.selectionBehavior();
        this.iconBehavior();
        this.popupBehavior();
    }

    private void comboBehavior() {
        MFXComboBox comboBox = this.getComboBox();
        comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!comboBox.isEditable()) {
                return;
            }
            switch (event.getCode()) {
                case ENTER: {
                    comboBox.commit(comboBox.getText());
                    break;
                }
                case Z: {
                    if (!event.isShiftDown() || !event.isControlDown()) break;
                    comboBox.cancel(comboBox.getText());
                }
            }
        });
        comboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.updateValue(newValue);
            this.popup.hide();
        });
        comboBox.valueProperty().addListener(invalidated -> Event.fireEvent((EventTarget)comboBox, (Event)new ActionEvent()));
        comboBox.delegateSelectionProperty().addListener((observable, oldValue, newValue) -> {
            if (!comboBox.isAllowEdit() && !comboBox.isSelectable()) {
                comboBox.selectRange(0, 0);
            }
        });
        comboBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && !comboBox.isSelectable()) {
                comboBox.selectRange(0, 0);
            }
        });
    }

    private void selectionBehavior() {
        MFXComboBox<T> comboBox = this.getComboBox();
        ISingleSelectionModel selectionModel = comboBox.getSelectionModel();
        ((SingleSelectionModel)selectionModel).selectedIndexProperty().addListener((arg_0, arg_1, arg_2) -> MFXComboBoxSkin.lambda$selectionBehavior$5(comboBox, (ComboBoxSelectionModel)selectionModel, arg_0, arg_1, arg_2));
    }

    private void iconBehavior() {
        MFXComboBox<T> comboBox = this.getComboBox();
        Node trailingIcon = comboBox.getTrailingIcon();
        if (trailingIcon != null) {
            trailingIcon.addEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
        }
        comboBox.trailingIconProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
            }
            if (newValue != null) {
                newValue.addEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
            }
        });
        this.popup.showingProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                comboBox.hide();
                if (trailingIcon instanceof MFXIconWrapper) {
                    MFXIconWrapper icon = (MFXIconWrapper)trailingIcon;
                    icon.getRippleGenerator().generateRipple(null);
                }
                this.animateIcon(comboBox.getTrailingIcon(), false);
            }
        });
    }

    private void popupBehavior() {
        MFXComboBox<T> comboBox = this.getComboBox();
        this.popup.setOnShowing(event -> Event.fireEvent((EventTarget)comboBox, (Event)new Event((Object)this.popup, (EventTarget)comboBox, MFXComboBox.ON_SHOWING)));
        this.popup.setOnShown(event -> Event.fireEvent((EventTarget)comboBox, (Event)new Event((Object)this.popup, (EventTarget)comboBox, MFXComboBox.ON_SHOWN)));
        this.popup.setOnHiding(event -> Event.fireEvent((EventTarget)comboBox, (Event)new Event((Object)this.popup, (EventTarget)comboBox, MFXComboBox.ON_HIDING)));
        this.popup.setOnHidden(event -> Event.fireEvent((EventTarget)comboBox, (Event)new Event((Object)this.popup, (EventTarget)comboBox, MFXComboBox.ON_HIDDEN)));
        comboBox.showingProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.popup.show((Node)comboBox, comboBox.getPopupAlignment(), comboBox.getPopupOffsetX(), comboBox.getPopupOffsetY());
                this.animateIcon(comboBox.getTrailingIcon(), true);
            }
        });
        this.popup.addEventFilter(WindowEvent.WINDOW_SHOWING, event -> AnimationUtils.PauseBuilder.build().setDuration(20.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)end -> {
            int selectedIndex;
            if (comboBox.isScrollOnOpen() && (selectedIndex = comboBox.getSelectedIndex()) >= 0) {
                this.virtualFlow.scrollTo(selectedIndex);
            }
        })).getAnimation().play());
    }

    protected void updateValue(T item) {
        MFXComboBox<T> comboBox = this.getComboBox();
        String s = "";
        if (item != null) {
            StringConverter<T> converter = comboBox.getConverter();
            s = converter != null ? converter.toString(item) : item.toString();
        }
        comboBox.setText(s);
        comboBox.positionCaret(s.length());
    }

    protected void animateIcon(Node icon, boolean showing) {
        MFXComboBox<T> comboBox = this.getComboBox();
        if (icon == null || comboBox.getAnimationProvider() == null) {
            return;
        }
        comboBox.getAnimationProvider().apply(icon, showing).play();
    }

    protected MFXPopup createPopup() {
        final MFXComboBox comboBox = this.getComboBox();
        MFXPopup popup = new MFXPopup(){

            @Override
            public String getUserAgentStylesheet() {
                return comboBox.getUserAgentStylesheet();
            }
        };
        popup.getStyleClass().add((Object)"combo-popup");
        popup.setPopupStyleableParent((Parent)comboBox);
        popup.setAutoHide(true);
        popup.setConsumeAutoHidingEvents(true);
        this.popupManager = event -> {
            if (comboBox.getItems().isEmpty()) {
                return;
            }
            comboBox.show();
        };
        popup.setContent(this.createPopupContent());
        return popup;
    }

    protected Node createPopupContent() {
        final MFXComboBox<T> comboBox = this.getComboBox();
        if (this.virtualFlow == null) {
            this.virtualFlow = new SimpleVirtualFlow<T, Cell<T>>(comboBox.itemsProperty(), comboBox.getCellFactory(), Orientation.VERTICAL){

                public String getUserAgentStylesheet() {
                    return comboBox.getUserAgentStylesheet();
                }
            };
            this.virtualFlow.cellFactoryProperty().bind(comboBox.cellFactoryProperty());
            this.virtualFlow.prefWidthProperty().bind((ObservableValue)comboBox.widthProperty());
        }
        return this.virtualFlow;
    }

    public MFXComboBox<T> getComboBox() {
        return (MFXComboBox)this.getSkinnable();
    }

    public void dispose() {
        super.dispose();
        MFXComboBox<T> comboBox = this.getComboBox();
        if (comboBox.getTrailingIcon() != null) {
            comboBox.getTrailingIcon().removeEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
        }
        this.popupManager = null;
        this.virtualFlow = null;
    }

    private static /* synthetic */ void lambda$selectionBehavior$5(MFXComboBox comboBox, ComboBoxSelectionModel selectionModel, ObservableValue observable, Number oldValue, Number newValue) {
        if (!comboBox.valueProperty().isBound()) {
            comboBox.setValue(selectionModel.getSelectedItem());
        }
    }
}

