/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.base.AbstractMFXListView;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import javafx.animation.Animation;
import javafx.animation.KeyValue;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class MFXListViewSkin<T>
extends SkinBase<AbstractMFXListView<T, ?>> {
    private final ScrollBar hBar;
    private final ScrollBar vBar;
    private Animation hideBars;
    private Animation showBars;

    public MFXListViewSkin(AbstractMFXListView<T, ?> listView, SimpleVirtualFlow<T, ?> virtualFlow) {
        super(listView);
        this.hBar = virtualFlow.getHBar();
        this.vBar = virtualFlow.getVBar();
        virtualFlow.getStylesheets().setAll((Object[])new String[]{listView.getUserAgentStylesheet()});
        this.hideBars = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.millis((double)400.0), new KeyValue((WritableValue)this.vBar.opacityProperty(), (Object)0.0, MFXAnimationFactory.INTERPOLATOR_V1), new KeyValue((WritableValue)this.hBar.opacityProperty(), (Object)0.0, MFXAnimationFactory.INTERPOLATOR_V1))).getAnimation();
        this.showBars = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.millis((double)400.0), new KeyValue((WritableValue)this.vBar.opacityProperty(), (Object)1.0, MFXAnimationFactory.INTERPOLATOR_V1), new KeyValue((WritableValue)this.hBar.opacityProperty(), (Object)1.0, MFXAnimationFactory.INTERPOLATOR_V1))).getAnimation();
        if (listView.isHideScrollBars()) {
            this.vBar.setOpacity(0.0);
            this.hBar.setOpacity(0.0);
        }
        listView.setEffect((Effect)MFXDepthManager.shadowOf(listView.getDepthLevel()));
        this.getChildren().setAll((Object[])new Node[]{virtualFlow});
        this.setListeners();
    }

    private void setListeners() {
        AbstractMFXListView listView = (AbstractMFXListView)this.getSkinnable();
        this.setScrollBarHandlers();
        listView.depthLevelProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                listView.setEffect((Effect)MFXDepthManager.shadowOf(listView.getDepthLevel()));
            }
        });
        listView.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> listView.requestFocus());
    }

    private void setScrollBarHandlers() {
        AbstractMFXListView listView = (AbstractMFXListView)this.getSkinnable();
        listView.setOnMouseExited(event -> {
            if (listView.isHideScrollBars()) {
                this.hideBars.setDelay(listView.getHideAfter());
                if (this.hBar.isPressed()) {
                    this.hBar.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                            if (!newValue.booleanValue()) {
                                MFXListViewSkin.this.hideBars.play();
                            }
                            MFXListViewSkin.this.hBar.pressedProperty().removeListener((ChangeListener)this);
                        }
                    });
                    return;
                }
                if (this.vBar.isPressed()) {
                    this.vBar.pressedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                            if (!newValue.booleanValue()) {
                                MFXListViewSkin.this.hideBars.play();
                            }
                            MFXListViewSkin.this.vBar.pressedProperty().removeListener((ChangeListener)this);
                        }
                    });
                    return;
                }
                this.hideBars.play();
            }
        });
        listView.setOnMouseEntered(event -> {
            if (this.hideBars.getStatus().equals((Object)Animation.Status.RUNNING)) {
                this.hideBars.stop();
            }
            this.showBars.play();
        });
        listView.hideScrollBarsProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.hideBars.play();
            } else {
                this.showBars.play();
            }
            if (newValue.booleanValue() && this.hideBars.getStatus() != Animation.Status.RUNNING || this.vBar.getOpacity() != 0.0 || this.hBar.getOpacity() != 0.0) {
                this.vBar.setOpacity(0.0);
                this.hBar.setOpacity(0.0);
            }
        });
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 350.0 + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + 200.0 + rightInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((AbstractMFXListView)this.getSkinnable()).prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((AbstractMFXListView)this.getSkinnable()).prefWidth(height);
    }

    public void dispose() {
        super.dispose();
        if (this.hideBars != null) {
            this.hideBars = null;
        }
        if (this.showBars != null) {
            this.showBars = null;
        }
    }
}

