/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXPaginatedTableView;
import io.github.palexdev.materialfx.controls.MFXPagination;
import io.github.palexdev.materialfx.controls.MFXTableRow;
import io.github.palexdev.materialfx.skins.MFXTableViewSkin;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class MFXPaginatedTableViewSkin<T>
extends MFXTableViewSkin<T> {
    private final MFXPagination pagination;
    private boolean init = false;

    public MFXPaginatedTableViewSkin(MFXPaginatedTableView<T> tableView, SimpleVirtualFlow<T, MFXTableRow<T>> rowsFlow) {
        super(tableView, rowsFlow);
        rowsFlow.setMinHeight(Double.NEGATIVE_INFINITY);
        rowsFlow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.pagination = new MFXPagination();
        this.pagination.pagesToShowProperty().bind((ObservableValue)tableView.pagesToShowProperty());
        this.pagination.maxPageProperty().bind((ObservableValue)tableView.maxPageProperty());
        this.pagination.setCurrentPage(tableView.getCurrentPage());
        tableView.currentPageProperty().bindBidirectional((Property)this.pagination.currentPageProperty());
        this.container.getChildren().remove((Object)this.footer);
        this.container.getChildren().add((Object)this.buildFooter());
        this.addListeners();
    }

    private void addListeners() {
        MFXPaginatedTableView tableView = (MFXPaginatedTableView)this.getSkinnable();
        tableView.virtualFlowInitializedProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.init && newValue.booleanValue()) {
                this.rowsFlow.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> (double)tableView.getRowsPerPage() * this.rowsFlow.getCellHeight(), (Observable[])new Observable[]{tableView.rowsPerPageProperty()}));
                int current = tableView.getCurrentPage();
                if (current != 1) {
                    AnimationUtils.PauseBuilder.build().setDuration(20.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> tableView.goToPage(current))).getAnimation().play();
                }
                this.init = true;
            }
        });
    }

    @Override
    protected StackPane buildFooter() {
        StackPane footer = super.buildFooter();
        if (this.pagination == null) {
            return footer;
        }
        footer.getChildren().add((Object)this.pagination);
        StackPane.setAlignment((Node)this.pagination, (Pos)Pos.CENTER);
        return footer;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double footerWidth = leftInset + this.footer.prefWidth(-1.0) + this.pagination.prefWidth(-1.0) * 2.0 + 10.0 + rightInset;
        return Math.max(footerWidth, super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset));
    }
}

