/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXPagination;
import io.github.palexdev.materialfx.controls.cell.MFXPage;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class MFXPaginationSkin
extends SkinBase<MFXPagination> {
    private Pane container;
    private final MFXIconWrapper leftArrow;
    private final MFXIconWrapper rightArrow;
    private Pane bar;
    private final ObservableList<MFXPage> pages = FXCollections.observableArrayList();

    public MFXPaginationSkin(MFXPagination pagination) {
        super((Control)pagination);
        this.leftArrow = new MFXIconWrapper("mfx-chevron-left", 12.0, 32.0).defaultRippleGeneratorBehavior();
        this.rightArrow = new MFXIconWrapper("mfx-chevron-right", 12.0, 32.0).defaultRippleGeneratorBehavior();
        NodeUtils.makeRegionCircular((Region)this.leftArrow);
        NodeUtils.makeRegionCircular((Region)this.rightArrow);
        this.leftArrow.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> pagination.setCurrentPage(pagination.getCurrentPage() - 1));
        this.rightArrow.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> pagination.setCurrentPage(pagination.getCurrentPage() + 1));
        this.buildBar();
        this.buildPages();
        Bindings.bindContent((List)this.bar.getChildren(), this.pages);
        this.container = this.buildContainer();
        this.addListeners();
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    private void addListeners() {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        pagination.pageCellFactoryProperty().addListener(invalidated -> {
            this.pages.clear();
            this.buildPages();
        });
        pagination.currentPageProperty().addListener(invalidated -> this.buildPages());
        pagination.maxPageProperty().addListener(invalidated -> {
            this.buildPages();
            int current = pagination.getCurrentPage();
            int max = pagination.getMaxPage();
            if (max > current) {
                pagination.setCurrentPage(max);
            }
        });
        pagination.indexesSupplierProperty().addListener(invalidated -> this.buildPages());
        pagination.ellipseStringProperty().addListener(invalidated -> {
            this.pages.clear();
            this.buildPages();
        });
        pagination.orientationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Orientation.HORIZONTAL) {
                this.leftArrow.setRotate(0.0);
                this.rightArrow.setRotate(0.0);
            } else {
                this.leftArrow.setRotate(90.0);
                this.rightArrow.setRotate(90.0);
            }
            this.pages.clear();
            this.buildBar();
            this.buildPages();
            this.container = this.buildContainer();
            this.getChildren().setAll((Object[])new Node[]{this.container});
        });
        pagination.showPopupForTruncatedPagesProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.updateBetweens();
            }
        });
    }

    protected Pane buildContainer() {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        if (pagination.getOrientation() == Orientation.HORIZONTAL) {
            HBox box = new HBox(5.0, new Node[]{this.leftArrow, this.bar, this.rightArrow});
            box.setAlignment(Pos.CENTER);
            return box;
        }
        VBox box = new VBox(5.0, new Node[]{this.leftArrow, this.bar, this.rightArrow});
        box.setAlignment(Pos.CENTER);
        return box;
    }

    protected void buildBar() {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        this.bar = pagination.getOrientation() == Orientation.HORIZONTAL ? new HBox(5.0) : new VBox(5.0);
        this.bar.getStyleClass().add((Object)"pages-bar");
    }

    protected void buildPages() {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        if (!this.pages.isEmpty()) {
            if (this.pages.size() != pagination.getMaxPage()) {
                this.supplyPages(pagination.getMaxPage() - this.pages.size());
            }
            this.updatePages();
            this.updateBetweens();
            return;
        }
        this.supplyPages(Math.min(pagination.getMaxPage(), pagination.getPagesToShow()));
        this.updatePages();
        this.updateBetweens();
    }

    protected void supplyPages(int num) {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        ArrayList<MFXPage> list = new ArrayList<MFXPage>();
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                list.add(pagination.getPageCellFactory().apply(i + 1));
            }
            this.pages.addAll(list);
        } else {
            int i = 1;
            int toRemove = Math.abs(num);
            while (toRemove > 0) {
                MFXPage page = (MFXPage)((Object)this.pages.get(this.pages.size() - i));
                list.add(page);
                --toRemove;
                ++i;
            }
            this.pages.removeAll(list);
        }
    }

    protected void updatePages() {
        MFXPagination pagination = (MFXPagination)this.getSkinnable();
        List<Integer> indexes = pagination.getIndexesSupplier().get();
        for (int i = 0; i < indexes.size(); ++i) {
            MFXPage page = (MFXPage)((Object)this.pages.get(i));
            page.updateItem(indexes.get(i));
        }
    }

    protected void updateBetweens() {
        if (!((MFXPagination)this.getSkinnable()).isShowPopupForTruncatedPages()) {
            return;
        }
        for (int i = 0; i < this.pages.size(); ++i) {
            MFXPage page = (MFXPage)((Object)this.pages.get(i));
            if (page.getIndex() == -1) {
                MFXPage pageBefore = (MFXPage)((Object)this.pages.get(i - 1));
                MFXPage pageAfter = (MFXPage)((Object)this.pages.get(i + 1));
                page.setBetween(NumberRange.of(pageBefore.getIndex() + 1, pageAfter.getIndex() - 1));
                continue;
            }
            page.setBetween(null);
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXPagination)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXPagination)this.getSkinnable()).prefHeight(-1.0);
    }
}

