/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXProgressBar;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;

public class MFXProgressBarSkin
extends SkinBase<MFXProgressBar> {
    private final StackPane container;
    private final Rectangle track = this.buildRectangle("track");
    private final Rectangle bar1;
    private final Rectangle bar2;
    private ParallelTransition indeterminateAnimation;

    public MFXProgressBarSkin(MFXProgressBar progressBar) {
        super((Control)progressBar);
        this.track.heightProperty().bind((ObservableValue)progressBar.heightProperty());
        this.track.widthProperty().bind((ObservableValue)progressBar.widthProperty());
        this.bar1 = this.buildRectangle("bar1");
        this.bar1.heightProperty().bind((ObservableValue)progressBar.heightProperty());
        this.bar2 = this.buildRectangle("bar2");
        this.bar2.heightProperty().bind((ObservableValue)progressBar.heightProperty());
        this.bar2.visibleProperty().bind((ObservableValue)progressBar.indeterminateProperty());
        Rectangle clip = new Rectangle();
        clip.heightProperty().bind((ObservableValue)progressBar.heightProperty());
        clip.widthProperty().bind((ObservableValue)progressBar.widthProperty());
        clip.arcHeightProperty().bind((ObservableValue)this.track.arcHeightProperty());
        clip.arcWidthProperty().bind((ObservableValue)this.track.arcWidthProperty());
        Group group = new Group(new Node[]{this.track, this.bar1, this.bar2});
        group.setClip((Node)clip);
        group.setManaged(false);
        this.container = new StackPane(new Node[]{group});
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.setListeners();
    }

    private void setListeners() {
        MFXProgressBar progressBar = (MFXProgressBar)this.getSkinnable();
        progressBar.progressProperty().addListener((observable, oldValue, newValue) -> this.updateBars());
        progressBar.widthProperty().addListener((observable, oldValue, newValue) -> {
            if (!progressBar.isVisible() || progressBar.isDisabled()) {
                return;
            }
            this.resetBars();
            this.updateBars();
        });
        progressBar.visibleProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.resetBars();
                return;
            }
            this.resetBars();
            this.updateBars();
        });
        progressBar.disabledProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.resetBars();
                return;
            }
            this.resetBars();
            this.updateBars();
        });
        progressBar.parentProperty().addListener((observable, oldValue, newValue) -> {
            this.resetBars();
            this.updateBars();
        });
        NodeUtils.waitForScene((Node)progressBar, () -> {
            if (!progressBar.isVisible() || progressBar.isDisabled()) {
                return;
            }
            this.resetBars();
            this.updateBars();
        }, true, false);
        progressBar.animationSpeedProperty().addListener((observable, oldValue, newValue) -> {
            this.resetBars();
            this.updateBars();
        });
    }

    protected void updateBars() {
        MFXProgressBar progressBar = (MFXProgressBar)this.getSkinnable();
        if (progressBar.isIndeterminate()) {
            this.playIndeterminateAnimation();
        } else {
            this.resetBars();
            this.updateProgress();
        }
    }

    protected void resetBars() {
        if (this.indeterminateAnimation != null) {
            this.indeterminateAnimation.stop();
            this.indeterminateAnimation.getChildren().clear();
            this.indeterminateAnimation = null;
        }
        this.bar1.setLayoutX(0.0);
        this.bar1.setScaleX(1.0);
        this.bar1.setWidth(0.0);
        this.bar2.setLayoutX(0.0);
        this.bar2.setScaleX(1.0);
        this.bar2.setWidth(0.0);
    }

    protected void updateProgress() {
        MFXProgressBar progressBar = (MFXProgressBar)this.getSkinnable();
        double width = progressBar.getWidth() * (progressBar.getProgress() * 100.0) / 100.0;
        this.bar1.setWidth(width);
    }

    protected void playIndeterminateAnimation() {
        MFXProgressBar progressBar = (MFXProgressBar)this.getSkinnable();
        if (this.indeterminateAnimation != null) {
            return;
        }
        double width = progressBar.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        Timeline bar1Animation = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(Duration.ONE, new KeyValue((WritableValue)this.bar1.scaleXProperty(), (Object)0.7), new KeyValue((WritableValue)this.bar1.layoutXProperty(), (Object)(-width)), new KeyValue((WritableValue)this.bar1.widthProperty(), (Object)(width / 2.0)), new KeyValue((WritableValue)this.bar2.layoutXProperty(), (Object)(-width)), new KeyValue((WritableValue)this.bar2.widthProperty(), (Object)(width / 2.0))), AnimationUtils.KeyFrames.of(750.0, this.bar1.scaleXProperty(), Double.valueOf(1.25), Interpolator.EASE_BOTH), AnimationUtils.KeyFrames.of(1300.0, this.bar1.layoutXProperty(), Double.valueOf(width), Interpolator.LINEAR), AnimationUtils.KeyFrames.of(1100.0, this.bar1.scaleXProperty(), Double.valueOf(1.0), Interpolator.EASE_OUT)).getAnimation();
        Timeline bar2Animation = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(1100.0, new KeyValue((WritableValue)this.bar2.layoutXProperty(), (Object)(width * 2.0), Interpolator.LINEAR), new KeyValue((WritableValue)this.bar2.scaleXProperty(), (Object)2, Interpolator.EASE_BOTH))).setDelay(1100.0).getAnimation();
        this.indeterminateAnimation = (ParallelTransition)AnimationUtils.ParallelBuilder.build().add((Animation)bar1Animation).add((Animation)bar2Animation).setCycleCount(-1).setRate(progressBar.getAnimationSpeed()).getAnimation();
        this.indeterminateAnimation.play();
    }

    protected Rectangle buildRectangle(String styleClass) {
        Rectangle rectangle = new Rectangle();
        rectangle.getStyleClass().setAll((Object[])new String[]{styleClass});
        rectangle.setStroke((Paint)Color.TRANSPARENT);
        rectangle.setStrokeLineCap(StrokeLineCap.ROUND);
        rectangle.setStrokeLineJoin(StrokeLineJoin.ROUND);
        rectangle.setStrokeType(StrokeType.INSIDE);
        rectangle.setStrokeWidth(0.0);
        return rectangle;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(100.0, leftInset + this.bar1.prefWidth(((MFXProgressBar)this.getSkinnable()).getWidth()) + rightInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(5.0, this.bar1.prefHeight(width)) + topInset + bottomInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXProgressBar)this.getSkinnable()).prefHeight(width);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXProgressBar)this.getSkinnable()).prefWidth(height);
    }

    public void dispose() {
        super.dispose();
        if (this.indeterminateAnimation != null) {
            this.indeterminateAnimation.stop();
            this.indeterminateAnimation.getChildren().clear();
            this.indeterminateAnimation = null;
        }
    }
}

