/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXProgressSpinner;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class MFXProgressSpinnerSkin
extends SkinBase<MFXProgressSpinner> {
    private boolean isValid = false;
    private boolean wasIndeterminate = false;
    private double arcLength = -1.0;
    private final Arc arc = new Arc();
    private final Arc track;
    private final StackPane arcPane;
    private final Rectangle fillRect;
    private final Text text;
    private Timeline animation;

    public MFXProgressSpinnerSkin(MFXProgressSpinner spinner) {
        super((Control)spinner);
        this.arc.setManaged(false);
        this.arc.setStartAngle(0.0);
        this.arc.setLength(180.0);
        this.arc.getStyleClass().setAll((Object[])new String[]{"arc"});
        this.arc.setFill((Paint)Color.TRANSPARENT);
        this.arc.setStrokeWidth(3.0);
        this.track = new Arc();
        this.track.setManaged(false);
        this.track.setStartAngle(0.0);
        this.track.setLength(360.0);
        this.track.setStrokeWidth(3.0);
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.track.setFill((Paint)Color.TRANSPARENT);
        this.fillRect = new Rectangle();
        this.fillRect.setFill((Paint)Color.TRANSPARENT);
        this.text = new Text();
        this.text.getStyleClass().setAll((Object[])new String[]{"text", "percentage"});
        Group group = new Group(new Node[]{this.fillRect, this.track, this.arc, this.text});
        group.setManaged(false);
        this.arcPane = new StackPane(new Node[]{group});
        this.arcPane.setPrefSize(50.0, 50.0);
        this.getChildren().setAll((Object[])new Node[]{this.arcPane});
        this.setListeners();
    }

    private void setListeners() {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        spinner.indeterminateProperty().addListener((observable, oldValue, newValue) -> this.reset());
        spinner.progressProperty().addListener((observable, oldValue, newValue) -> this.updateProgress());
        spinner.visibleProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.resetAndStop();
            } else {
                this.updateAnimation();
            }
        });
        spinner.disabledProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.resetAndStop();
                return;
            }
            this.updateAnimation();
        });
        spinner.parentProperty().addListener((observable, oldValue, newValue) -> this.updateAnimation());
        spinner.color1Property().addListener((observable, oldValue, newValue) -> {
            if (!spinner.isIndeterminate()) {
                return;
            }
            this.clearAnimation();
            this.reset();
        });
        spinner.color2Property().addListener((observable, oldValue, newValue) -> {
            if (!spinner.isIndeterminate()) {
                return;
            }
            this.clearAnimation();
            this.reset();
        });
        spinner.color3Property().addListener((observable, oldValue, newValue) -> {
            if (!spinner.isIndeterminate()) {
                return;
            }
            this.clearAnimation();
            this.reset();
        });
        spinner.color4Property().addListener((observable, oldValue, newValue) -> {
            if (!spinner.isIndeterminate()) {
                return;
            }
            this.clearAnimation();
            this.reset();
        });
        NodeUtils.waitForScene((Node)spinner, () -> {
            if (!spinner.isVisible() || spinner.isDisabled()) {
                this.resetAndStop();
                return;
            }
            this.updateAnimation();
        }, true, false);
    }

    protected void updateProgress() {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        boolean isIndeterminate = spinner.isIndeterminate();
        if (!isIndeterminate || !this.wasIndeterminate) {
            this.arcLength = -360.0 * spinner.getProgress();
            spinner.requestLayout();
        }
        this.wasIndeterminate = isIndeterminate;
    }

    private void reset() {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        if (spinner.isIndeterminate()) {
            if (this.animation == null) {
                this.createAnimation();
            }
        } else {
            this.clearAnimation();
            this.arc.setStartAngle(spinner.getStartingAngle());
            this.updateProgress();
        }
    }

    private void resetAndStop() {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        if (spinner.isIndeterminate()) {
            if (this.animation != null) {
                this.animation.stop();
            }
        } else {
            this.clearAnimation();
            this.arc.setStartAngle(spinner.getStartingAngle());
            this.updateProgress();
        }
    }

    private void clearAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation.getKeyFrames().clear();
            this.animation = null;
        }
    }

    private void updateAnimation() {
        boolean isTreeVisible;
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        boolean bl = isTreeVisible = spinner.isVisible() && spinner.getParent() != null && spinner.getScene() != null;
        if (this.animation != null) {
            this.pauseTimeline(!isTreeVisible);
        } else if (isTreeVisible) {
            this.createAnimation();
        }
    }

    private void createAnimation() {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        Color color1 = spinner.getColor1();
        Color color2 = spinner.getColor2();
        Color color3 = spinner.getColor3();
        Color color4 = spinner.getColor4();
        if (!spinner.isIndeterminate()) {
            return;
        }
        if (this.arc.getStroke() == null) {
            this.arc.setStroke((Paint)color1);
        }
        KeyFrame endingFrame = new KeyFrame(Duration.seconds((double)5.6), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(1845.0 + spinner.getStartingAngle()), Interpolator.LINEAR)});
        KeyFrame[] allFrames = (KeyFrame[])Stream.of(this.getKeyFrames(0.0, 0.0, (Paint)color1), this.getKeyFrames(450.0, 1.4, (Paint)color2), this.getKeyFrames(900.0, 2.8, (Paint)color3), this.getKeyFrames(1350.0, 4.2, (Paint)color4), {endingFrame}).flatMap(Arrays::stream).toArray(KeyFrame[]::new);
        if (this.animation != null) {
            this.animation.stop();
            this.animation.getKeyFrames().clear();
        }
        this.animation = AnimationUtils.TimelineBuilder.build().add(allFrames).setDelay(Duration.ZERO).setCycleCount(-1).getAnimation();
        if (spinner.isVisible() && !spinner.isDisabled()) {
            this.animation.playFromStart();
        }
    }

    private void pauseTimeline(boolean pause) {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        if (spinner.isIndeterminate()) {
            if (this.animation == null) {
                this.createAnimation();
            }
            if (pause) {
                this.animation.pause();
            } else {
                this.animation.play();
            }
        }
    }

    private KeyFrame[] getKeyFrames(double angle, double duration, Paint color) {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        KeyFrame kf1 = new KeyFrame(Duration.seconds((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 45.0 + spinner.getStartingAngle()), Interpolator.LINEAR)});
        KeyFrame kf2 = new KeyFrame(Duration.seconds((double)(duration + 0.4)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 90.0 + spinner.getStartingAngle()), Interpolator.LINEAR)});
        KeyFrame kf3 = new KeyFrame(Duration.seconds((double)(duration + 0.7)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 135.0 + spinner.getStartingAngle()), Interpolator.LINEAR)});
        KeyFrame kf4 = new KeyFrame(Duration.seconds((double)(duration + 1.1)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(angle + 435.0 + spinner.getStartingAngle()), Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.strokeProperty(), (Object)color, Interpolator.EASE_BOTH)});
        return new KeyFrame[]{kf1, kf2, kf3, kf4};
    }

    private void updateArcLayout(double radius, double arcSize) {
        this.arc.setRadiusX(radius);
        this.arc.setRadiusY(radius);
        this.arc.setCenterX(arcSize / 2.0);
        this.arc.setCenterY(arcSize / 2.0);
        this.track.setRadiusX(radius);
        this.track.setRadiusY(radius);
        this.track.setCenterX(arcSize / 2.0);
        this.track.setCenterY(arcSize / 2.0);
        this.track.setStrokeWidth(this.arc.getStrokeWidth());
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        if (-1.0 == spinner.getRadius()) {
            return spinner.prefHeight(width);
        }
        return spinner.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        if (-1.0 == spinner.getRadius()) {
            return spinner.prefWidth(height);
        }
        return spinner.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.arcPane.prefWidth(-1.0);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.arcPane.prefHeight(-1.0);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        MFXProgressSpinner spinner = (MFXProgressSpinner)this.getSkinnable();
        double strokeWidth = this.arc.getStrokeWidth();
        double radius = Math.min(contentWidth, contentHeight) / 2.0 - strokeWidth / 2.0;
        double arcSize = this.snapSizeX(radius * 2.0 + strokeWidth);
        this.arcPane.resizeRelocate((contentWidth - arcSize) / 2.0 + 1.0, (contentHeight - arcSize) / 2.0 + 1.0, arcSize, arcSize);
        this.updateArcLayout(radius, arcSize);
        this.fillRect.setWidth(arcSize);
        this.fillRect.setHeight(arcSize);
        if (!this.isValid) {
            this.reset();
            this.isValid = true;
        }
        if (!spinner.isIndeterminate()) {
            this.arc.setLength(this.arcLength);
            if (this.text.isVisible()) {
                double progress = spinner.getProgress();
                int intProgress = (int)Math.round(progress * 100.0);
                Font font = this.text.getFont();
                this.text.setFont(Font.font((String)font.getFamily(), (double)(radius / 1.7)));
                this.text.setText((progress > 1.0 ? 100 : intProgress) + "%");
                this.text.relocate((arcSize - this.text.getLayoutBounds().getWidth()) / 2.0, (arcSize - this.text.getLayoutBounds().getHeight()) / 2.0);
            }
        }
    }
}

