/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXRadioButton;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.skins.base.MFXLabeledSkinBase;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.animation.KeyValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;

public class MFXRadioButtonSkin
extends MFXLabeledSkinBase<MFXRadioButton> {
    private final StackPane radioContainer;
    private final Circle radio = new Circle();
    private final Circle dot;
    private final MFXCircleRippleGenerator rippleGenerator;

    public MFXRadioButtonSkin(MFXRadioButton radioButton) {
        super(radioButton);
        this.radio.getStyleClass().add((Object)"radio");
        this.radio.radiusProperty().bind((ObservableValue)radioButton.radiusProperty());
        this.radio.setSmooth(true);
        this.dot = new Circle();
        this.dot.getStyleClass().add((Object)"dot");
        this.dot.radiusProperty().bind((ObservableValue)radioButton.radiusProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        this.dot.setSmooth(true);
        this.radioContainer = new StackPane(new Node[]{this.radio, this.dot});
        this.rippleGenerator = new MFXCircleRippleGenerator((Region)this.radioContainer);
        this.rippleGenerator.setAnimateBackground(false);
        this.rippleGenerator.setClipSupplier(() -> null);
        this.rippleGenerator.setRipplePositionFunction(event -> {
            PositionBean position = new PositionBean();
            position.setX(this.radio.getBoundsInParent().getCenterX());
            position.setY(this.radio.getBoundsInParent().getCenterY());
            return position;
        });
        this.radioContainer.getChildren().add(0, (Object)this.rippleGenerator);
        this.rippleGenerator.setManaged(false);
        this.updateAlignment();
        this.initContainer();
        this.getChildren().setAll((Object[])new Node[]{this.topContainer});
        this.addListeners();
    }

    private void animate(boolean selected) {
        MFXRadioButton radioButton = (MFXRadioButton)this.getSkinnable();
        double radius = radioButton.getRadius();
        double scale = (radius - radioButton.getRadioGap()) / radius;
        AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(100.0, new KeyValue((WritableValue)this.dot.scaleXProperty(), (Object)(selected ? scale : 0.0), Interpolators.EASE_OUT.toInterpolator()), new KeyValue((WritableValue)this.dot.scaleYProperty(), (Object)(selected ? scale : 0.0), Interpolators.EASE_OUT.toInterpolator()))).getAnimation().play();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        MFXRadioButton radioButton = (MFXRadioButton)this.getSkinnable();
        radioButton.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> radioButton.fire());
        radioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.animate((boolean)newValue);
            this.rippleGenerator.generateRipple(null);
        });
        radioButton.radioGapProperty().addListener(invalidated -> {
            if (radioButton.isSelected()) {
                double radius = radioButton.getRadius();
                double scale = (radius - radioButton.getRadioGap()) / radius;
                this.dot.setScaleX(scale);
                this.dot.setScaleY(scale);
            }
        });
        NodeUtils.waitForSkin((Control)radioButton, () -> {
            if (radioButton.isSelected()) {
                this.animate(true);
            }
        }, false, false);
    }

    @Override
    protected Pane getControlContainer() {
        return this.radioContainer;
    }
}

