/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.controls.MFXSlider;
import io.github.palexdev.materialfx.enums.SliderEnums;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.NumberUtils;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;

public class MFXSliderSkin
extends SkinBase<MFXSlider> {
    private final Rectangle track;
    private final Rectangle bar;
    private final Group group;
    private final Group ticksGroup;
    private final NumberAxis ticksAxis;
    private Node thumb;
    private Region popup;
    private final LayoutData layoutData = new LayoutData();
    private final PopupManager popupManager = new PopupManager();
    private double preDragThumbPos;
    private Point2D dragStart;
    private EventHandler<MouseEvent> thumbPressHandler;
    private EventHandler<MouseEvent> thumbDragHandler;
    private EventHandler<MouseEvent> trackPressedHandler;
    private boolean mousePressed = false;
    private boolean trackPressed = false;
    private boolean keyPressed = false;
    private boolean keyWasPressed = false;
    private PauseTransition releaseTimer = new PauseTransition();
    private boolean isSnapping = false;
    private boolean wasSnapping = false;

    public MFXSliderSkin(MFXSlider slider) {
        super((Control)slider);
        this.track = this.buildRectangle("track");
        this.track.heightProperty().bind((ObservableValue)slider.heightProperty());
        this.track.widthProperty().bind((ObservableValue)slider.widthProperty());
        this.track.setFill((Paint)Color.rgb((int)82, (int)0, (int)237, (double)0.3));
        this.track.setStroke((Paint)Color.GOLD);
        this.bar = this.buildRectangle("bar");
        this.bar.heightProperty().bind((ObservableValue)slider.heightProperty());
        this.bar.setFill((Paint)Color.GREEN);
        this.bar.setMouseTransparent(true);
        this.thumb = slider.getThumbSupplier().get();
        this.popup = slider.getPopupSupplier().get();
        this.popup.setVisible(false);
        this.popup.setOpacity(0.0);
        this.ticksAxis = new NumberAxis(slider.getMin(), slider.getMax(), slider.getTickUnit());
        this.ticksAxis.setMinorTickCount(slider.getMinorTicksCount());
        this.ticksAxis.setManaged(false);
        this.ticksAxis.setMouseTransparent(true);
        this.ticksAxis.setTickMarkVisible(false);
        this.ticksAxis.setTickLabelsVisible(false);
        Rectangle clip = new Rectangle();
        clip.heightProperty().bind((ObservableValue)slider.heightProperty());
        clip.widthProperty().bind((ObservableValue)slider.widthProperty());
        clip.arcHeightProperty().bind((ObservableValue)this.track.arcHeightProperty());
        clip.arcWidthProperty().bind((ObservableValue)this.track.arcWidthProperty());
        this.ticksGroup = new Group(new Node[]{this.ticksAxis});
        this.ticksGroup.setClip((Node)clip);
        this.ticksGroup.setManaged(false);
        this.ticksGroup.setMouseTransparent(true);
        this.group = new Group(new Node[]{this.track, this.ticksGroup, this.bar, this.thumb, this.popup});
        this.group.setManaged(false);
        this.group.getStylesheets().add((Object)slider.getUserAgentStylesheet());
        this.getChildren().setAll((Object[])new Node[]{this.group});
        this.releaseTimer.setDuration(Duration.millis((double)800.0));
        this.releaseTimer.setOnFinished(event -> this.hidePopup());
        this.thumbPressHandler = event -> {
            this.dragStart = this.thumb.localToParent(event.getX(), event.getY());
            this.preDragThumbPos = (slider.getValue() - slider.getMin()) / (slider.getMax() - slider.getMin());
        };
        this.thumbDragHandler = this::handleDrag;
        this.trackPressedHandler = this::trackPressed;
        if (slider.getOrientation() == Orientation.VERTICAL) {
            slider.setRotate(-90.0);
        } else {
            slider.setRotate(0.0);
        }
        this.setBehavior();
    }

    protected void setBehavior() {
        this.sliderHandlers();
        this.sliderListeners();
        this.skinBehavior();
    }

    private void sliderHandlers() {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        slider.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> slider.requestFocus());
        slider.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.mousePressed = true;
            Node intersectedNode = event.getPickResult().getIntersectedNode();
            if (intersectedNode == this.track || NodeUtils.inHierarchy(intersectedNode, this.thumb)) {
                this.showPopup();
            }
        });
        slider.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.mousePressed = false;
            this.releaseTimer.playFromStart();
        });
        slider.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            double val;
            if (!slider.isEnableKeyboard()) {
                return;
            }
            double d = val = event.isShiftDown() || event.isControlDown() ? slider.getAlternativeUnitIncrement() : slider.getUnitIncrement();
            if (this.isIncreaseKey((KeyEvent)event)) {
                this.keyPressed = true;
                this.keyWasPressed = true;
                slider.setValue(NumberUtils.clamp(slider.getValue() + val, slider.getMin(), slider.getMax()));
            } else if (this.isDecreaseKey((KeyEvent)event)) {
                this.keyPressed = true;
                this.keyWasPressed = true;
                slider.setValue(NumberUtils.clamp(slider.getValue() - val, slider.getMin(), slider.getMax()));
            }
        });
    }

    private void sliderListeners() {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        slider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.isSnapping) {
                this.updateLayout();
            }
        });
        slider.minProperty().addListener((observable, oldValue, newValue) -> {
            slider.setValue(0.0);
            this.ticksAxis.setLowerBound(newValue.doubleValue());
            slider.requestLayout();
        });
        slider.maxProperty().addListener((observable, oldValue, newValue) -> {
            slider.setValue(0.0);
            this.ticksAxis.setUpperBound(newValue.doubleValue());
            slider.requestLayout();
        });
        slider.minorTicksCountProperty().addListener((observable, oldValue, newValue) -> {
            this.ticksAxis.setMinorTickCount(newValue.intValue());
            this.ticksAxis.requestAxisLayout();
            slider.requestLayout();
        });
        slider.tickUnitProperty().addListener((observable, oldValue, newValue) -> {
            this.ticksAxis.setTickUnit(newValue.doubleValue());
            this.ticksAxis.requestAxisLayout();
            slider.requestLayout();
        });
        slider.showTicksAtEdgesProperty().addListener((observable, oldValue, newValue) -> slider.requestLayout());
        slider.popupSupplierProperty().addListener((observable, oldValue, newValue) -> {
            this.handlePopupChange();
            slider.requestLayout();
            this.popupManager.initPopup();
        });
        slider.thumbSupplierProperty().addListener((observable, oldValue, newValue) -> {
            this.handleThumbChange();
            slider.requestLayout();
        });
        slider.bidirectionalProperty().addListener((observable, oldValue, newValue) -> slider.requestLayout());
        slider.orientationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Orientation.VERTICAL) {
                slider.setRotate(-90.0);
            } else {
                slider.setRotate(0.0);
            }
        });
        slider.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && this.keyPressed) {
                AnimationUtils.PauseBuilder.build().setDuration(Duration.millis((double)100.0)).runWhile((BooleanExpression)slider.focusedProperty(), () -> ((MFXSlider)slider).requestFocus(), () -> {
                    this.keyPressed = false;
                });
            }
        });
    }

    private void skinBehavior() {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, this.thumbPressHandler);
        this.thumb.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.thumbDragHandler);
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, this.trackPressedHandler);
        this.popupManager.initPopup();
        this.ticksAxis.visibleProperty().bind((ObservableValue)slider.showMinorTicksProperty());
        this.ticksAxis.needsLayoutProperty().addListener((observable, oldValue, newValue) -> this.layoutData.updateTicksData());
    }

    private void updateLayout() {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        if (slider.getSliderMode() == SliderEnums.SliderMode.SNAP_TO_TICKS && !this.keyWasPressed) {
            this.isSnapping = true;
            this.wasSnapping = true;
            double closest = this.layoutData.findNearestTick();
            slider.setValue(closest);
            this.isSnapping = false;
        }
        this.layoutData.update(false);
        if (!this.mousePressed) {
            this.showPopup();
            this.releaseTimer.playFromStart();
        }
        if ((this.trackPressed || this.wasSnapping) && slider.isAnimateOnPress()) {
            this.wasSnapping = false;
            AnimationUtils.ParallelBuilder.build().add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.bar.layoutXProperty(), (Object)this.layoutData.barX, MFXAnimationFactory.INTERPOLATOR_V1)})).add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.thumb.layoutXProperty(), (Object)this.layoutData.thumbX, MFXAnimationFactory.INTERPOLATOR_V1)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.bar.widthProperty(), (Object)Math.abs(this.layoutData.barW), MFXAnimationFactory.INTERPOLATOR_V1)})).getAnimation().play();
        } else {
            this.thumb.setLayoutX(this.layoutData.thumbX);
            this.bar.setLayoutX(this.layoutData.barX);
            this.bar.setWidth(Math.abs(this.layoutData.barW));
        }
        this.keyWasPressed = false;
    }

    private void handleDrag(MouseEvent event) {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        this.trackPressed = false;
        Point2D curr = this.thumb.localToParent(event.getX(), event.getY());
        double dragPos = curr.getX() - this.dragStart.getX();
        double pos = this.preDragThumbPos + dragPos / slider.getWidth();
        double val = NumberUtils.clamp(pos * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMin(), slider.getMax());
        slider.setValue(val);
    }

    private void trackPressed(MouseEvent event) {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        this.trackPressed = true;
        double pos = event.getX() / slider.getWidth();
        double val = NumberUtils.clamp(pos * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMin(), slider.getMax());
        slider.setValue(val);
    }

    private void handlePopupChange() {
        Supplier<Region> popupSupplier;
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        int index = -1;
        if (this.popup != null) {
            index = this.group.getChildren().indexOf((Object)this.popup);
            this.popup.layoutXProperty().unbind();
            this.popup.layoutYProperty().unbind();
            this.group.getChildren().remove((Object)this.popup);
        }
        Region region = this.popup = (popupSupplier = slider.getPopupSupplier()) != null ? popupSupplier.get() : null;
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.setOpacity(0.0);
            this.group.getChildren().add(index >= 0 ? index : this.group.getChildren().size() - 1, (Object)this.popup);
            this.popupManager.initPopup();
        }
    }

    private void handleThumbChange() {
        Supplier<Node> thumbSupplier;
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        int index = -1;
        if (this.thumb != null) {
            index = this.group.getChildren().indexOf((Object)this.thumb);
            this.thumb.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.thumbPressHandler);
            this.thumb.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.thumbDragHandler);
            this.group.getChildren().remove((Object)this.thumb);
        }
        Node node = this.thumb = (thumbSupplier = slider.getThumbSupplier()) != null ? thumbSupplier.get() : null;
        if (this.thumb != null) {
            this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, this.thumbPressHandler);
            this.thumb.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.thumbDragHandler);
            this.group.getChildren().add(index >= 0 ? index : this.group.getChildren().size() - 1, (Object)this.thumb);
        }
    }

    protected void showPopup() {
        if (this.popup == null) {
            return;
        }
        this.releaseTimer.stop();
        AnimationUtils.SequentialBuilder.build().add((Animation)AnimationUtils.PauseBuilder.build().setDuration(Duration.ONE).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.popup.setVisible(true))).getAnimation()).add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1.0, Interpolator.EASE_IN)})).getAnimation().play();
    }

    protected void hidePopup() {
        if (this.popup == null) {
            return;
        }
        AnimationUtils.SequentialBuilder.build().add(new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0.0, Interpolator.EASE_OUT)})).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.popup.setVisible(false))).getAnimation().play();
    }

    protected Rectangle buildRectangle(String styleClass) {
        Rectangle rectangle = new Rectangle();
        rectangle.getStyleClass().setAll((Object[])new String[]{styleClass});
        rectangle.setStroke((Paint)Color.TRANSPARENT);
        rectangle.setStrokeLineCap(StrokeLineCap.ROUND);
        rectangle.setStrokeLineJoin(StrokeLineJoin.ROUND);
        rectangle.setStrokeType(StrokeType.INSIDE);
        rectangle.setStrokeWidth(0.0);
        return rectangle;
    }

    protected Node buildTick() {
        return new MFXFontIcon("mfx-circle", 4.0);
    }

    private boolean isIncreaseKey(KeyEvent event) {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        return event.getCode() == KeyCode.UP && slider.getOrientation() == Orientation.VERTICAL || event.getCode() == KeyCode.RIGHT && slider.getOrientation() == Orientation.HORIZONTAL;
    }

    private boolean isDecreaseKey(KeyEvent event) {
        MFXSlider slider = (MFXSlider)this.getSkinnable();
        return event.getCode() == KeyCode.DOWN && slider.getOrientation() == Orientation.VERTICAL || event.getCode() == KeyCode.LEFT && slider.getOrientation() == Orientation.HORIZONTAL;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(100.0, leftInset + this.bar.prefWidth(((MFXSlider)this.getSkinnable()).getWidth()) + rightInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(6.0, this.bar.prefHeight(width)) + topInset + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXSlider)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    public void dispose() {
        super.dispose();
        this.thumb.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.thumbPressHandler);
        this.thumb.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.thumbDragHandler);
        this.thumbPressHandler = null;
        this.thumbDragHandler = null;
        this.track.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.trackPressedHandler);
        this.trackPressedHandler = null;
        this.releaseTimer = null;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        this.layoutData.update(true);
        this.thumb.relocate(this.layoutData.thumbX, this.layoutData.thumbY);
        this.bar.relocate(this.layoutData.barX, 0.0);
        this.bar.setWidth(Math.abs(this.layoutData.barW));
        this.ticksAxis.resize(w, h);
    }

    protected class LayoutData {
        private double zeroPos;
        private double thumbX;
        private double thumbY;
        private double barW;
        private double barX;
        private final ObservableList<TickData> ticksData = FXCollections.observableArrayList();
        private double ticksY;

        protected LayoutData() {
        }

        public void update(boolean isFullUpdate) {
            boolean ignoreBidirectional;
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            boolean bl = ignoreBidirectional = slider.getMin() > 0.0 || slider.getMax() < 0.0 || !slider.isBidirectional();
            if (isFullUpdate) {
                double val = ignoreBidirectional ? slider.getMin() : 0.0;
                this.zeroPos = NumberUtils.mapOneRangeToAnother(val, NumberRange.of(slider.getMin(), slider.getMax()), NumberRange.of(0.0, slider.getWidth()), 2);
                this.zeroPos = NumberUtils.clamp(this.zeroPos, 0.0, slider.getWidth());
            }
            this.thumbX = MFXSliderSkin.this.snapPositionX(NumberUtils.mapOneRangeToAnother(slider.getValue(), NumberRange.of(slider.getMin(), slider.getMax()), NumberRange.of(0.0, slider.getWidth()), 2) - this.halfThumbWidth());
            this.thumbY = MFXSliderSkin.this.snapPositionY(-this.halfThumbHeight() + slider.getHeight() / 2.0);
            if (!slider.isBidirectional() || ignoreBidirectional) {
                this.barW = this.thumbX - this.zeroPos + this.halfThumbWidth() * 3.0;
                this.barX = this.zeroPos - this.halfThumbWidth();
            } else {
                this.barW = slider.getValue() < 0.0 ? this.thumbX - this.zeroPos - this.halfThumbWidth() : this.thumbX - this.zeroPos + this.halfThumbWidth() * 3.0;
                this.barX = slider.getValue() < 0.0 ? this.zeroPos + this.barW + this.halfThumbWidth() : this.zeroPos - this.halfThumbWidth();
            }
        }

        public void updateTicksData() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            List ticksX = MFXSliderSkin.this.ticksAxis.getTickMarks().stream().map(Axis.TickMark::getPosition).collect(Collectors.toList());
            if (!ticksX.stream().allMatch(d -> d == 0.0)) {
                MFXSliderSkin.this.ticksGroup.getChildren().removeAll(this.getTicks());
                this.ticksData.clear();
                ObservableList tickMarks = MFXSliderSkin.this.ticksAxis.getTickMarks();
                for (int i = 0; i < tickMarks.size(); ++i) {
                    Axis.TickMark tickMark = (Axis.TickMark)MFXSliderSkin.this.ticksAxis.getTickMarks().get(i);
                    TickData tickData = new TickData();
                    tickData.tick = MFXSliderSkin.this.buildTick();
                    tickData.tick.getStyleClass().setAll((Object[])new String[]{NumberUtils.isEven(i) ? "tick-even" : "tick-odd"});
                    tickData.tickVal = (Double)((Number)tickMark.getValue());
                    tickData.x = MFXSliderSkin.this.snapPositionX((Double)ticksX.get(i) - tickData.halfTickWidth() / 1.5);
                    this.ticksData.add((Object)tickData);
                    if (i != tickMarks.size() - 1) continue;
                    tickData.x -= tickData.halfTickWidth();
                }
                this.ticksY = MFXSliderSkin.this.snapPositionY(-((TickData)this.ticksData.get(0)).halfTickHeight() + slider.getHeight() / 2.0);
                this.positionTicks();
            }
        }

        public void positionTicks() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            if (!slider.isShowMajorTicks()) {
                return;
            }
            for (int i = 0; i < this.ticksData.size(); ++i) {
                Axis.TickMark tickMark = (Axis.TickMark)MFXSliderSkin.this.ticksAxis.getTickMarks().get(i);
                TickData tickData = (TickData)this.ticksData.get(i);
                if (!slider.isShowTicksAtEdges() && (((Double)((Number)tickMark.getValue())).doubleValue() == slider.getMax() || ((Double)((Number)tickMark.getValue())).doubleValue() == slider.getMin())) continue;
                MFXSliderSkin.this.ticksGroup.getChildren().add((Object)tickData.tick);
                tickData.tick.relocate(tickData.x, this.ticksY);
            }
        }

        public double findNearestTick() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            double currVal = slider.getValue();
            return NumberUtils.closestValueTo(currVal, this.ticksData.stream().map(TickData::getTickVal).collect(Collectors.toList()));
        }

        public List<Node> getTicks() {
            return this.ticksData.stream().map(TickData::getTick).collect(Collectors.toList());
        }

        public double halfThumbWidth() {
            return MFXSliderSkin.this.thumb.prefWidth(-1.0) / 2.0;
        }

        public double halfThumbHeight() {
            return MFXSliderSkin.this.thumb.prefHeight(-1.0) / 2.0;
        }
    }

    protected class PopupManager {
        private DoubleBinding xBinding;
        private DoubleBinding yBinding;
        private DoubleBinding rBinding;

        protected PopupManager() {
        }

        private void initPopup() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            if (MFXSliderSkin.this.popup == null) {
                return;
            }
            this.xBinding = Bindings.createDoubleBinding(this::computeXPos, (Observable[])new Observable[]{MFXSliderSkin.this.thumb.layoutXProperty(), MFXSliderSkin.this.popup.widthProperty(), slider.thumbSupplierProperty(), slider.orientationProperty(), slider.popupSideProperty()});
            this.yBinding = Bindings.createDoubleBinding(this::computeYPos, (Observable[])new Observable[]{MFXSliderSkin.this.thumb.layoutYProperty(), MFXSliderSkin.this.popup.heightProperty(), slider.thumbSupplierProperty(), slider.orientationProperty(), slider.popupSideProperty()});
            this.rBinding = Bindings.createDoubleBinding(this::computeRotate, (Observable[])new Observable[]{slider.orientationProperty(), slider.popupSideProperty()});
            MFXSliderSkin.this.popup.rotateProperty().bind((ObservableValue)this.rBinding);
            MFXSliderSkin.this.popup.layoutXProperty().bind((ObservableValue)this.xBinding);
            MFXSliderSkin.this.popup.layoutYProperty().bind((ObservableValue)this.yBinding);
        }

        private double computeXPos() {
            double x;
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            if (slider.getOrientation() == Orientation.HORIZONTAL) {
                x = MFXSliderSkin.this.thumb.getLayoutX() - (MFXSliderSkin.this.popup.getWidth() - MFXSliderSkin.this.layoutData.halfThumbWidth() * 2.0) / 2.0;
                x = slider.getPopupSide() == SliderEnums.SliderPopupSide.DEFAULT ? x : x - 1.0;
            } else {
                x = MFXSliderSkin.this.thumb.getLayoutX() - MFXSliderSkin.this.popup.getHeight() / 2.0 + MFXSliderSkin.this.layoutData.halfThumbWidth() / 2.0 + 1.0;
            }
            return MFXSliderSkin.this.snapPositionX(x);
        }

        private double computeYPos() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            double y = slider.getOrientation() == Orientation.HORIZONTAL ? (slider.getPopupSide() == SliderEnums.SliderPopupSide.DEFAULT ? -(MFXSliderSkin.this.popup.getHeight() + MFXSliderSkin.this.layoutData.halfThumbHeight() + slider.getPopupPadding()) : slider.getHeight() + MFXSliderSkin.this.layoutData.halfThumbHeight() + slider.getPopupPadding()) : (slider.getPopupSide() == SliderEnums.SliderPopupSide.DEFAULT ? -(MFXSliderSkin.this.popup.getWidth() + MFXSliderSkin.this.layoutData.halfThumbHeight() + slider.getPopupPadding() / 1.5) : slider.getHeight() * 1.5 + MFXSliderSkin.this.layoutData.halfThumbHeight() + slider.getPopupPadding());
            return MFXSliderSkin.this.snapPositionY(y);
        }

        private double computeRotate() {
            MFXSlider slider = (MFXSlider)MFXSliderSkin.this.getSkinnable();
            if (slider.getOrientation() == Orientation.HORIZONTAL && slider.getPopupSide() == SliderEnums.SliderPopupSide.OTHER_SIDE) {
                return 180.0;
            }
            if (slider.getOrientation() == Orientation.VERTICAL) {
                return slider.getPopupSide() == SliderEnums.SliderPopupSide.DEFAULT ? 90.0 : -90.0;
            }
            return 0.0;
        }
    }

    protected static class TickData {
        private Node tick;
        private double tickVal;
        private double x;

        protected TickData() {
        }

        public Node getTick() {
            return this.tick;
        }

        public double getTickVal() {
            return this.tickVal;
        }

        public double getX() {
            return this.x;
        }

        public double halfTickHeight() {
            return this.tick == null ? 0.0 : this.tick.prefHeight(-1.0) / 2.0;
        }

        public double halfTickWidth() {
            return this.tick == null ? 0.0 : this.tick.prefWidth(-1.0) / 2.0;
        }
    }
}

