/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.collections.TransformableListWrapper;
import io.github.palexdev.materialfx.controls.MFXFilterPane;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTableRow;
import io.github.palexdev.materialfx.controls.MFXTableView;
import io.github.palexdev.materialfx.dialogs.MFXDialogs;
import io.github.palexdev.materialfx.dialogs.MFXStageDialog;
import io.github.palexdev.materialfx.enums.SortState;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlow;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;

public class MFXTableViewSkin<T>
extends SkinBase<MFXTableView<T>> {
    protected final VBox container;
    protected final HBox columnsContainer;
    protected final SimpleVirtualFlow<T, MFXTableRow<T>> rowsFlow;
    protected final StackPane footer;
    private final MFXFilterPane<T> filterPane;
    private final MFXStageDialog filterDialog;
    private MFXTableColumn<T> sortedColumn;

    public MFXTableViewSkin(MFXTableView<T> tableView, SimpleVirtualFlow<T, MFXTableRow<T>> rowsFlow) {
        super(tableView);
        this.rowsFlow = rowsFlow;
        this.columnsContainer = new HBox();
        this.columnsContainer.getStyleClass().add((Object)"columns-container");
        Bindings.bindContent((List)this.columnsContainer.getChildren(), tableView.getTableColumns());
        this.filterPane = new MFXFilterPane();
        Bindings.bindContent(this.filterPane.getFilters(), tableView.getFilters());
        this.footer = this.buildFooter();
        this.container = new VBox(new Node[]{this.columnsContainer, rowsFlow});
        if (tableView.isFooterVisible()) {
            this.container.getChildren().add((Object)this.footer);
        }
        this.filterDialog = MFXDialogs.filter(this.filterPane).setShowMinimize(false).toStageDialogBuilder().setDraggable(true).setOwnerNode((Pane)this.container).setCenterInOwnerNode(true).initOwner(tableView.getScene().getWindow()).initModality(Modality.APPLICATION_MODAL).get();
        this.filterDialog.setOnShown(event -> this.filterDialog.toFront());
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.addListeners();
    }

    private void addListeners() {
        MFXTableView tableView = (MFXTableView)this.getSkinnable();
        tableView.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> tableView.requestFocus());
        tableView.addEventFilter(MFXTableColumn.MFXTableColumnEvent.SORTING_EVENT, event -> {
            TransformableListWrapper transformableList = tableView.getTransformableList();
            MFXTableColumn column = event.getColumn();
            if (this.sortedColumn != null && this.sortedColumn != column) {
                this.sortedColumn.setSortState(SortState.UNSORTED);
            }
            switch (event.getSortState()) {
                case UNSORTED: {
                    transformableList.setComparator(null, false);
                    break;
                }
                case ASCENDING: {
                    transformableList.setComparator(event.getComparator(), false);
                    break;
                }
                case DESCENDING: {
                    transformableList.setComparator(event.getComparator(), true);
                }
            }
            this.sortedColumn = column;
        });
        tableView.getTableColumns().addListener(invalidated -> {
            for (MFXTableRow row : this.rowsFlow.getCells().values()) {
                row.buildCells();
            }
        });
        tableView.footerVisibleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.container.getChildren().add((Object)this.footer);
            } else {
                this.container.getChildren().remove((Object)this.footer);
            }
        });
    }

    protected StackPane buildFooter() {
        MFXTableView tableView = (MFXTableView)this.getSkinnable();
        MFXIconWrapper filterIcon = new MFXIconWrapper("mfx-filter-alt", 16.0, 32.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper clearFilterIcon = new MFXIconWrapper("mfx-filter-alt-clear", 16.0, 32.0).defaultRippleGeneratorBehavior();
        NodeUtils.makeRegionCircular((Region)filterIcon);
        NodeUtils.makeRegionCircular((Region)clearFilterIcon);
        filterIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.filterDialog.showDialog();
        });
        clearFilterIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.filterPane.getActiveFilters().clear();
            tableView.getTransformableList().setPredicate(null);
        });
        this.filterPane.setOnFilter((EventHandler<MouseEvent>)((EventHandler)event -> {
            tableView.getTransformableList().setPredicate(this.filterPane.filter());
            this.filterDialog.close();
        }));
        this.filterPane.setOnReset((EventHandler<MouseEvent>)((EventHandler)event -> this.filterPane.getActiveFilters().clear()));
        HBox container = new HBox(10.0, new Node[]{filterIcon, clearFilterIcon});
        StackPane.setAlignment((Node)container, (Pos)Pos.CENTER_LEFT);
        StackPane stackPane = new StackPane(new Node[]{container});
        stackPane.getStyleClass().add((Object)"default-footer");
        return stackPane;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXTableView)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXTableView)this.getSkinnable()).prefHeight(-1.0);
    }
}

