/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXToggleButton;
import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.skins.base.MFXLabeledSkinBase;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;

public class MFXToggleButtonSkin
extends MFXLabeledSkinBase<MFXToggleButton> {
    private final StackPane toggleContainer;
    private final Circle circle;
    private final Line line = new Line();
    private final MFXCircleRippleGenerator rippleGenerator;

    public MFXToggleButtonSkin(MFXToggleButton toggleButton) {
        super(toggleButton);
        this.line.getStyleClass().add((Object)"line");
        this.line.endXProperty().bind((ObservableValue)toggleButton.lengthProperty().subtract((ObservableNumberValue)this.line.strokeWidthProperty()));
        this.line.strokeWidthProperty().bind((ObservableValue)toggleButton.radiusProperty().multiply(1.5));
        this.line.setSmooth(true);
        this.circle = new Circle();
        this.circle.getStyleClass().add((Object)"circle");
        this.circle.radiusProperty().bind((ObservableValue)toggleButton.radiusProperty());
        this.circle.setSmooth(true);
        this.circle.setEffect((Effect)MFXDepthManager.shadowOf(DepthLevel.LEVEL1));
        this.toggleContainer = new StackPane(new Node[]{this.line, this.circle});
        this.toggleContainer.setAlignment(Pos.CENTER_LEFT);
        this.toggleContainer.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.toggleContainer.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.toggleContainer.setPickOnBounds(false);
        this.rippleGenerator = new MFXCircleRippleGenerator((Region)this.toggleContainer);
        this.rippleGenerator.setAnimateBackground(false);
        this.rippleGenerator.setClipSupplier(() -> null);
        this.rippleGenerator.setRipplePositionFunction(event -> {
            PositionBean position = new PositionBean();
            position.xProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.circle.localToParent(this.circle.getLayoutBounds()).getCenterX(), (Observable[])new Observable[]{this.circle.translateXProperty()}));
            position.yProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.circle.localToParent(this.circle.getLayoutBounds()).getCenterY(), (Observable[])new Observable[]{this.circle.layoutBoundsProperty()}));
            return position;
        });
        this.toggleContainer.getChildren().add(0, (Object)this.rippleGenerator);
        this.updateAlignment();
        this.initContainer();
        this.getChildren().setAll((Object[])new Node[]{this.topContainer});
        this.addListeners();
    }

    private void buildAndPlayAnimation(boolean selection) {
        double endX = selection ? this.line.getBoundsInParent().getMaxX() - this.circle.getRadius() * 2.0 : 0.0;
        AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(0.0, (EventHandler<ActionEvent>)((EventHandler)event -> this.rippleGenerator.generateRipple(null))), AnimationUtils.KeyFrames.of(150.0, this.circle.translateXProperty(), Double.valueOf(endX), Interpolators.INTERPOLATOR_V1)).getAnimation().play();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        MFXToggleButton toggleButton = (MFXToggleButton)this.getSkinnable();
        toggleButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.buildAndPlayAnimation((boolean)newValue));
        NodeUtils.waitForSkin((Control)toggleButton, () -> {
            double endX = toggleButton.isSelected() ? this.line.getLayoutBounds().getWidth() - this.circle.getRadius() * 2.0 : 0.0;
            AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(150.0, this.circle.translateXProperty(), Double.valueOf(endX), Interpolators.INTERPOLATOR_V1)).getAnimation().play();
        }, false, true);
    }

    @Override
    protected Pane getControlContainer() {
        return this.toggleContainer;
    }
}

