/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.FloatExpression;
import javafx.beans.binding.IntegerExpression;
import javafx.beans.binding.LongExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;

public class BindingUtils {
    private BindingUtils() {
    }

    public static <T> ObjectProperty<T> toProperty(ObjectExpression<T> expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleObjectProperty property = new SimpleObjectProperty();
        property.bind(expression);
        return property;
    }

    public static IntegerProperty toProperty(IntegerExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleIntegerProperty property = new SimpleIntegerProperty();
        property.bind((ObservableValue)expression);
        return property;
    }

    public static LongProperty toProperty(LongExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleLongProperty property = new SimpleLongProperty();
        property.bind((ObservableValue)expression);
        return property;
    }

    public static FloatProperty toProperty(FloatExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleFloatProperty property = new SimpleFloatProperty();
        property.bind((ObservableValue)expression);
        return property;
    }

    public static DoubleProperty toProperty(DoubleExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleDoubleProperty property = new SimpleDoubleProperty();
        property.bind((ObservableValue)expression);
        return property;
    }

    public static BooleanProperty toProperty(BooleanExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleBooleanProperty property = new SimpleBooleanProperty();
        property.bind((ObservableValue)expression);
        return property;
    }

    public static StringProperty toProperty(StringExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("The argument cannot be null!");
        }
        SimpleStringProperty property = new SimpleStringProperty();
        property.bind((ObservableValue)expression);
        return property;
    }
}

