/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.WeekFields;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DateTimeUtils {
    public static final int CALENDAR_ROWS = 6;
    public static final int CALENDAR_COLUMNS = 7;

    private DateTimeUtils() {
    }

    public static Integer[][] partialIntMonthMatrix(Locale locale, YearMonth yearMonth) {
        Map<DayOfWeek, Integer> weekDays = DateTimeUtils.weekDays(locale);
        Integer[][] matrix = new Integer[6][7];
        int start = weekDays.get(yearMonth.atDay(1).getDayOfWeek());
        int row = 0;
        int column = start;
        for (int i = 1; i <= yearMonth.lengthOfMonth(); ++i) {
            matrix[row][column] = i;
            if (++column != 7) continue;
            ++row;
            column = 0;
        }
        return matrix;
    }

    public static Day[][] partialDayMonthMatrix(Locale locale, YearMonth yearMonth) {
        Map<DayOfWeek, Integer> weekDays = DateTimeUtils.weekDays(locale);
        Day[][] matrix = new Day[6][7];
        int start = weekDays.get(yearMonth.atDay(1).getDayOfWeek());
        int row = 0;
        int column = start;
        for (int i = 1; i <= yearMonth.lengthOfMonth(); ++i) {
            DayOfWeek dayOfWeek = yearMonth.atDay(i).getDayOfWeek();
            matrix[row][column] = new Day(yearMonth, dayOfWeek, i);
            if (++column != 7) continue;
            ++row;
            column = 0;
        }
        return matrix;
    }

    public static Integer[][] fullIntMonthMatrix(Locale locale, YearMonth yearMonth) {
        Map<DayOfWeek, Integer> weekDays = DateTimeUtils.weekDays(locale);
        Integer[][] matrix = new Integer[6][7];
        int start = weekDays.get(yearMonth.atDay(1).getDayOfWeek());
        if (start != 0) {
            int day = yearMonth.plusMonths(-1L).atEndOfMonth().getDayOfMonth();
            for (int extraStart = start - 1; extraStart >= 0; --extraStart) {
                matrix[0][extraStart] = day;
                --day;
            }
        }
        int row = 0;
        int column = start;
        for (int i = 1; i <= yearMonth.lengthOfMonth(); ++i) {
            matrix[row][column] = i;
            if (++column != 7) continue;
            ++row;
            column = 0;
        }
        int end = start + yearMonth.lengthOfMonth() - 1;
        int day = 1;
        while (end < 41) {
            matrix[row][column] = day;
            if (++column == 7) {
                ++row;
                column = 0;
            }
            ++end;
            ++day;
        }
        return matrix;
    }

    public static Day[][] fullDayMonthMatrix(Locale locale, YearMonth yearMonth) {
        DayOfWeek dayOfWeek;
        Map<DayOfWeek, Integer> weekDays = DateTimeUtils.weekDays(locale);
        Day[][] matrix = new Day[6][7];
        int start = weekDays.get(yearMonth.atDay(1).getDayOfWeek());
        if (start != 0) {
            YearMonth previous = yearMonth.plusMonths(-1L);
            int day = previous.atEndOfMonth().getDayOfMonth();
            for (int extraStart = start - 1; extraStart >= 0; --extraStart) {
                dayOfWeek = yearMonth.plusMonths(-1L).atDay(day).getDayOfWeek();
                matrix[0][extraStart] = new Day(yearMonth, dayOfWeek, day);
                --day;
            }
        }
        int row = 0;
        int column = start;
        for (int i = 1; i <= yearMonth.lengthOfMonth(); ++i) {
            dayOfWeek = yearMonth.atDay(i).getDayOfWeek();
            matrix[row][column] = new Day(yearMonth, dayOfWeek, i);
            if (++column != 7) continue;
            ++row;
            column = 0;
        }
        YearMonth next = yearMonth.plusMonths(1L);
        int end = start + yearMonth.lengthOfMonth() - 1;
        int day = 1;
        while (end < 41) {
            DayOfWeek dayOfWeek2 = next.atDay(day).getDayOfWeek();
            matrix[row][column] = new Day(next, dayOfWeek2, day);
            if (++column == 7) {
                ++row;
                column = 0;
            }
            ++end;
            ++day;
        }
        return matrix;
    }

    public static int startIndexFor(YearMonth yearMonth, Locale locale) {
        Map<DayOfWeek, Integer> weekDays = DateTimeUtils.weekDays(locale);
        return weekDays.get(yearMonth.atDay(1).getDayOfWeek());
    }

    public static int endIndexFor(YearMonth yearMonth, Locale locale) {
        int start = DateTimeUtils.startIndexFor(yearMonth, locale);
        return start + yearMonth.lengthOfMonth() - 1;
    }

    public static Map<DayOfWeek, Integer> weekDays(Locale locale) {
        DayOfWeek firstDay = WeekFields.of(locale).getFirstDayOfWeek();
        return IntStream.range(0, 7).boxed().collect(Collectors.toMap(i -> firstDay.plus(i.intValue()), i -> i, (anInt, anInt2) -> anInt2, LinkedHashMap::new));
    }

    public static YearMonth dateToYearMonth(LocalDate date) {
        return YearMonth.of(date.getYear(), date.getMonth());
    }

    public static class Day {
        private final YearMonth yearMonth;
        private final DayOfWeek dayOfWeek;
        private final int monthDay;

        private Day(YearMonth yearMonth, DayOfWeek dayOfWeek, int monthDay) {
            this.yearMonth = yearMonth;
            this.dayOfWeek = dayOfWeek;
            this.monthDay = monthDay;
        }

        public YearMonth getYearMonth() {
            return this.yearMonth;
        }

        public DayOfWeek getDayOfWeek() {
            return this.dayOfWeek;
        }

        public int getMonthDay() {
            return this.monthDay;
        }
    }
}

