/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import java.util.EnumSet;
import java.util.function.Function;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class DragResizer {
    private final Region region;
    private double resizeMargin = 5.0;
    private Function<Region, Double> widthConstraintFunction = r -> r.prefWidth(-1.0);
    private Function<Region, Double> heightConstraintFunction = r -> r.prefHeight(-1.0);
    private boolean initialized = false;
    private Point2D mouseLocation;
    private Direction allowedDirection;
    private Direction draggingDirection = Direction.NONE;
    private boolean dragging;
    private final EventHandler<MouseEvent> mousePressed = this::handlePressed;
    private final EventHandler<MouseEvent> mouseDragged = this::handleDragged;
    private final EventHandler<MouseEvent> mouseMoved = this::handleMoved;
    private final EventHandler<MouseEvent> mouseReleased = this::handleReleased;

    public DragResizer(Region region, Direction direction) {
        this.region = region;
        this.allowedDirection = direction;
    }

    public DragResizer makeResizable() {
        this.region.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
        this.region.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
        this.region.addEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoved);
        this.region.addEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleased);
        return this;
    }

    public DragResizer uninstall() {
        this.region.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
        this.region.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
        this.region.removeEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoved);
        this.region.removeEventFilter(MouseEvent.MOUSE_RELEASED, this.mouseReleased);
        this.handleReleased(null);
        return this;
    }

    private void handlePressed(MouseEvent event) {
        if (this.isTopZone(event)) {
            this.draggingDirection = Direction.TOP;
        } else if (this.isRightZone(event)) {
            this.draggingDirection = Direction.RIGHT;
        } else if (this.isBottomZone(event)) {
            this.draggingDirection = Direction.BOTTOM;
        } else if (this.isLeftZone(event)) {
            this.draggingDirection = Direction.LEFT;
        } else {
            return;
        }
        this.dragging = true;
        if (!this.initialized) {
            this.region.setMinHeight(this.region.getHeight());
            this.region.setMinWidth(this.region.getWidth());
            this.initialized = true;
        }
        this.mouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
        event.consume();
    }

    private void handleDragged(MouseEvent event) {
        if (!this.dragging) {
            return;
        }
        double deltaX = event.getSceneX() - this.mouseLocation.getX();
        double deltaY = event.getSceneY() - this.mouseLocation.getY();
        double newWidth = this.region.getMinWidth();
        double newHeight = this.region.getMinHeight();
        switch (this.draggingDirection) {
            case TOP: {
                newHeight -= deltaY;
                break;
            }
            case RIGHT: {
                newWidth += deltaX;
                break;
            }
            case BOTTOM: {
                newHeight += deltaY;
                break;
            }
            case LEFT: {
                newWidth -= deltaX;
            }
        }
        double minW = this.widthConstraintFunction.apply(this.region);
        double minH = this.heightConstraintFunction.apply(this.region);
        if (newWidth < minW) {
            newWidth = minW;
        }
        if (newHeight < minH) {
            newHeight = minH;
        }
        this.region.setMinHeight(newHeight);
        this.region.setMinWidth(newWidth);
        this.mouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
    }

    private void handleMoved(MouseEvent event) {
        if (this.isTopZone(event) || this.draggingDirection == Direction.TOP) {
            this.region.setCursor(Cursor.N_RESIZE);
        } else if (this.isRightZone(event) || this.draggingDirection == Direction.RIGHT) {
            this.region.setCursor(Cursor.E_RESIZE);
        } else if (this.isBottomZone(event) || this.draggingDirection == Direction.BOTTOM) {
            this.region.setCursor(Cursor.S_RESIZE);
        } else if (this.isLeftZone(event) || this.draggingDirection == Direction.LEFT) {
            this.region.setCursor(Cursor.W_RESIZE);
        } else {
            this.region.setCursor(Cursor.DEFAULT);
        }
    }

    private void handleReleased(MouseEvent event) {
        this.initialized = false;
        this.dragging = false;
        this.draggingDirection = Direction.NONE;
        this.region.setCursor(Cursor.DEFAULT);
    }

    private boolean isTopZone(MouseEvent event) {
        return EnumSet.of(Direction.TOP, Direction.ALL).contains((Object)this.allowedDirection) && event.getY() < this.resizeMargin;
    }

    private boolean isRightZone(MouseEvent event) {
        return EnumSet.of(Direction.RIGHT, Direction.ALL).contains((Object)this.allowedDirection) && event.getX() > this.region.getWidth() - this.resizeMargin;
    }

    private boolean isBottomZone(MouseEvent event) {
        return EnumSet.of(Direction.BOTTOM, Direction.ALL).contains((Object)this.allowedDirection) && event.getY() > this.region.getHeight() - this.resizeMargin;
    }

    private boolean isLeftZone(MouseEvent event) {
        return EnumSet.of(Direction.LEFT, Direction.ALL).contains((Object)this.allowedDirection) && event.getX() < this.resizeMargin;
    }

    public double getResizeMargin() {
        return this.resizeMargin;
    }

    public DragResizer setResizeMargin(double resizeMargin) {
        this.resizeMargin = resizeMargin;
        return this;
    }

    public Function<Region, Double> getWidthConstraintFunction() {
        return this.widthConstraintFunction;
    }

    public DragResizer setWidthConstraintFunction(Function<Region, Double> widthConstraintFunction) {
        this.widthConstraintFunction = widthConstraintFunction;
        return this;
    }

    public Function<Region, Double> getHeightConstraintFunction() {
        return this.heightConstraintFunction;
    }

    public DragResizer setHeightConstraintFunction(Function<Region, Double> heightConstraintFunction) {
        this.heightConstraintFunction = heightConstraintFunction;
        return this;
    }

    public Direction getAllowedDirection() {
        return this.allowedDirection;
    }

    public DragResizer setAllowedDirection(Direction allowedDirection) {
        this.allowedDirection = allowedDirection;
        return this;
    }

    public static enum Direction {
        NONE,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT,
        ALL;

    }
}

