/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.beans.SizeBean;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Screen;

public class NodeUtils {
    private NodeUtils() {
    }

    public static void updateBackground(Region region, Paint fill) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, bf.getRadii(), bf.getInsets()));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void updateBackground(Region region, Paint fill, Insets backgroundInsets) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, bf.getRadii(), backgroundInsets));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void updateBackground(Region region, Paint fill, CornerRadii cornerRadii, Insets backgroundInsets) {
        Background background = region.getBackground();
        if (background == null || background.getFills().isEmpty()) {
            return;
        }
        ArrayList<BackgroundFill> fills = new ArrayList<BackgroundFill>();
        for (BackgroundFill bf : background.getFills()) {
            fills.add(new BackgroundFill(fill, cornerRadii, backgroundInsets));
        }
        region.setBackground(new Background((BackgroundFill[])fills.toArray(BackgroundFill[]::new)));
    }

    public static void setBackground(Region region, Paint fill) {
        NodeUtils.setBackground(region, fill, CornerRadii.EMPTY, Insets.EMPTY);
    }

    public static void setBackground(Region region, Paint fill, CornerRadii radius) {
        NodeUtils.setBackground(region, fill, radius, Insets.EMPTY);
    }

    public static void setBackground(Region region, Paint fill, CornerRadii radius, Insets insets) {
        region.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(fill, radius, insets)}));
    }

    public static CornerRadii parseCornerRadius(Region region) {
        Border border;
        CornerRadii backRadius = CornerRadii.EMPTY;
        CornerRadii bordRadius = CornerRadii.EMPTY;
        Background background = region.getBackground();
        if (background != null && !background.isEmpty()) {
            backRadius = ((BackgroundFill)background.getFills().get(0)).getRadii();
        }
        if ((border = region.getBorder()) != null && !border.isEmpty()) {
            bordRadius = ((BorderStroke)border.getStrokes().get(0)).getRadii();
        }
        return !backRadius.equals((Object)CornerRadii.EMPTY) ? backRadius : bordRadius;
    }

    public static void centerNodeInAnchorPane(Node node, double topBottom, double leftRight) {
        AnchorPane.setTopAnchor((Node)node, (Double)topBottom);
        AnchorPane.setBottomAnchor((Node)node, (Double)topBottom);
        AnchorPane.setLeftAnchor((Node)node, (Double)leftRight);
        AnchorPane.setRightAnchor((Node)node, (Double)leftRight);
    }

    public static boolean inHierarchy(Node node, Node element) {
        if (element == null) {
            return true;
        }
        while (node != null) {
            if (node == element) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean inHierarchy(Node node, MouseEvent event) {
        return NodeUtils.inHierarchy(node, event.getPickResult().getIntersectedNode());
    }

    public static boolean inHierarchy(MouseEvent event, Node node) {
        return NodeUtils.inHierarchy(event.getPickResult().getIntersectedNode(), node);
    }

    public static void makeRegionCircular(Region region) {
        Circle circle = new Circle();
        circle.radiusProperty().bind((ObservableValue)region.widthProperty().divide(2.0));
        circle.centerXProperty().bind((ObservableValue)region.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)region.heightProperty().divide(2.0));
        try {
            region.setClip((Node)circle);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not set region's clip to make it circular", ex);
        }
    }

    public static void makeRegionCircular(Region region, double radius) {
        Circle circle = new Circle(radius);
        circle.centerXProperty().bind((ObservableValue)region.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)region.heightProperty().divide(2.0));
        try {
            region.setClip((Node)circle);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not set region's clip to make it circular", ex);
        }
    }

    public static double getRegionHeight(Region region) {
        Group group = new Group(new Node[]{region});
        Scene scene = new Scene((Parent)group);
        group.applyCss();
        group.layout();
        group.getChildren().clear();
        return region.getHeight();
    }

    public static double getRegionWidth(Region region) {
        Group group = new Group(new Node[]{region});
        Scene scene = new Scene((Parent)group);
        group.applyCss();
        group.layout();
        group.getChildren().clear();
        return region.getWidth();
    }

    public static double getNodeHeight(Node node) {
        Group group = new Group(new Node[]{node});
        Scene scene = new Scene((Parent)group);
        group.applyCss();
        group.layout();
        double height = node.prefHeight(-1.0);
        group.getChildren().clear();
        return height;
    }

    public static double getNodeWidth(Node node) {
        Group group = new Group(new Node[]{node});
        Scene scene = new Scene((Parent)group);
        group.applyCss();
        group.layout();
        double width = node.prefWidth(-1.0);
        group.getChildren().clear();
        return width;
    }

    public static SizeBean getNodeSizes(Node node) {
        Group group = new Group(new Node[]{node});
        Scene scene = new Scene((Parent)group);
        group.applyCss();
        group.layout();
        SizeBean sizes = SizeBean.of(node.prefWidth(-1.0), node.prefHeight(-1.0));
        group.getChildren().clear();
        return sizes;
    }

    public static void addPrefWidth(Region region, double value) {
        double prefW = region.getPrefWidth();
        region.setPrefWidth(prefW + value);
    }

    public static void addPrefHeight(Region region, double value) {
        double prefH = region.getPrefHeight();
        region.setPrefHeight(prefH + value);
    }

    public static void fireDummyEvent(Node node) {
        Event.fireEvent((EventTarget)node, (Event)new MouseEvent(MouseEvent.MOUSE_PRESSED, 0.0, 0.0, 0.0, 0.0, MouseButton.PRIMARY, 1, false, false, false, false, true, false, false, false, false, false, null));
    }

    public static boolean isRightAlignment(Pos alignment) {
        return alignment == Pos.BASELINE_RIGHT || alignment == Pos.BOTTOM_RIGHT || alignment == Pos.CENTER_RIGHT || alignment == Pos.TOP_RIGHT;
    }

    public static ArrayList<Node> getAllNodes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeUtils.addAllDescendents(root, nodes);
        return nodes;
    }

    private static void addAllDescendents(Parent parent, ArrayList<Node> nodes) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            NodeUtils.addAllDescendents((Parent)node, nodes);
        }
    }

    public static void waitForSkin(final Control control, final Runnable action, boolean addListenerIfNotNull, final boolean isOneShot) {
        if (control.getSkin() != null) {
            action.run();
        }
        if (control.getSkin() == null || addListenerIfNotNull) {
            control.skinProperty().addListener(new ChangeListener<Skin<?>>(){

                public void changed(ObservableValue<? extends Skin<?>> observable, Skin<?> oldValue, Skin<?> newValue) {
                    if (newValue != null) {
                        action.run();
                        if (isOneShot) {
                            control.skinProperty().removeListener((ChangeListener)this);
                        }
                    }
                }
            });
        }
    }

    public static void waitForScene(final Node node, final Runnable action, boolean addListenerIfNotNull, final boolean isOneShot) {
        if (node.getScene() != null) {
            action.run();
        }
        if (node.getScene() == null || addListenerIfNotNull) {
            node.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                    if (newValue != null) {
                        action.run();
                        if (isOneShot) {
                            node.sceneProperty().removeListener((ChangeListener)this);
                        }
                    }
                }
            });
        }
    }

    public static boolean isPseudoClassActive(Control control, PseudoClass pseudoClass) {
        return control.getPseudoClassStates().contains((Object)pseudoClass);
    }

    public static Screen getScreenFor(Node node) {
        Bounds nodeBounds = node.localToScreen(node.getLayoutBounds());
        Rectangle2D boundsToRect = new Rectangle2D(nodeBounds.getMinX(), nodeBounds.getMinY(), nodeBounds.getWidth(), nodeBounds.getHeight());
        return Screen.getScreens().stream().filter(screen -> screen.getBounds().contains(boundsToRect)).findFirst().orElse(null);
    }
}

