/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.enums.NotificationPos;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class PositionUtils {
    private PositionUtils() {
    }

    public static boolean isTop(Pos pos) {
        return pos == Pos.TOP_LEFT || pos == Pos.TOP_CENTER || pos == Pos.TOP_RIGHT;
    }

    public static boolean isCenter(Pos pos) {
        return pos == Pos.CENTER_LEFT || pos == Pos.CENTER || pos == Pos.CENTER_RIGHT || pos == Pos.TOP_CENTER || pos == Pos.BOTTOM_CENTER;
    }

    public static boolean isBottom(Pos pos) {
        return pos == Pos.BOTTOM_LEFT || pos == Pos.BOTTOM_CENTER || pos == Pos.BOTTOM_RIGHT;
    }

    public static boolean isLeft(Pos pos) {
        return pos == Pos.TOP_LEFT || pos == Pos.CENTER_LEFT || pos == Pos.BOTTOM_LEFT;
    }

    public static boolean isRight(Pos pos) {
        return pos == Pos.TOP_RIGHT || pos == Pos.CENTER_RIGHT || pos == Pos.BOTTOM_RIGHT;
    }

    public static boolean isTop(NotificationPos pos) {
        return pos == NotificationPos.TOP_LEFT || pos == NotificationPos.TOP_CENTER || pos == NotificationPos.TOP_RIGHT;
    }

    public static boolean isCenter(NotificationPos pos) {
        return pos == NotificationPos.TOP_CENTER || pos == NotificationPos.BOTTOM_CENTER;
    }

    public static boolean isRight(NotificationPos pos) {
        return pos == NotificationPos.TOP_RIGHT || pos == NotificationPos.BOTTOM_RIGHT;
    }

    public static PositionBean computePosition(Region parent, Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos hAlignment, VPos vAlignment) {
        return PositionUtils.computePosition(parent, child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, margin, hAlignment, vAlignment, true);
    }

    public static PositionBean computePosition(Region parent, Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, Insets margin, HPos hAlignment, VPos vAlignment, boolean snapToPixel) {
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapToPixel) {
            snappedMargin = InsetsFactory.of(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double xPosition = PositionUtils.computeXPosition(parent, child, areaX, areaWidth, snappedMargin, false, hAlignment, snapToPixel);
        double yPosition = PositionUtils.computeYPosition(parent, child, areaY, areaHeight, areaBaselineOffset, snappedMargin, false, vAlignment, snapToPixel);
        return PositionBean.of(xPosition, yPosition);
    }

    public static double computeXPosition(Region parent, Node child, double areaX, double areaWidth, Insets margin, boolean snapMargin, HPos hAlignment, boolean snapToPixel) {
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapMargin) {
            snappedMargin = InsetsFactory.of(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double leftMargin = snappedMargin.getLeft();
        double rightMargin = snappedMargin.getRight();
        double xOffset = leftMargin + PositionUtils.computeXOffset(areaWidth - leftMargin - rightMargin, child.getLayoutBounds().getWidth(), hAlignment);
        double xPosition = areaX + xOffset;
        return snapToPixel ? parent.snapPositionX(xPosition) : xPosition;
    }

    public static double computeYPosition(Region parent, Node child, double areaY, double areaHeight, double areaBaselineOffset, Insets margin, boolean snapMargin, VPos vAlignment, boolean snapToPixel) {
        double bo;
        Insets snappedMargin;
        Insets insets = snappedMargin = margin == null ? Insets.EMPTY : margin;
        if (snapMargin) {
            snappedMargin = InsetsFactory.of(parent.snapSpaceY(snappedMargin.getTop()), parent.snapSpaceX(snappedMargin.getRight()), parent.snapSpaceY(snappedMargin.getBottom()), parent.snapSpaceX(snappedMargin.getLeft()));
        }
        double topMargin = snappedMargin.getTop();
        double bottomMargin = snappedMargin.getBottom();
        double yOffset = vAlignment == VPos.BASELINE ? ((bo = child.getBaselineOffset()) == Double.NEGATIVE_INFINITY ? areaBaselineOffset - child.getLayoutBounds().getHeight() : areaBaselineOffset - bo) : topMargin + PositionUtils.computeYOffset(areaHeight - topMargin - bottomMargin, child.getLayoutBounds().getHeight(), vAlignment);
        double yPosition = areaY + yOffset;
        return snapToPixel ? parent.snapPositionY(yPosition) : yPosition;
    }

    private static double computeXOffset(double areaWidth, double contentWidth, HPos hAlignment) {
        switch (hAlignment) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (areaWidth - contentWidth) / 2.0;
            }
            case RIGHT: {
                return areaWidth - contentWidth;
            }
        }
        throw new AssertionError((Object)"Unhandled hPos");
    }

    private static double computeYOffset(double areaHeight, double contentHeight, VPos vAlignment) {
        switch (vAlignment) {
            case BASELINE: 
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (areaHeight - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return areaHeight - contentHeight;
            }
        }
        throw new AssertionError((Object)"Unhandled vPos");
    }
}

