/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;

public class ScrollUtils {
    private ScrollUtils() {
    }

    public static boolean isTrackPad(ScrollEvent event, ScrollDirection scrollDirection) {
        switch (scrollDirection) {
            case UP: 
            case DOWN: {
                return Math.abs(event.getDeltaY()) < 10.0;
            }
            case LEFT: 
            case RIGHT: {
                return Math.abs(event.getDeltaX()) < 10.0;
            }
        }
        return false;
    }

    public static ScrollDirection determineScrollDirection(ScrollEvent event) {
        double deltaX = event.getDeltaX();
        double deltaY = event.getDeltaY();
        if (deltaY == 0.0) {
            return deltaX < 0.0 ? ScrollDirection.LEFT : ScrollDirection.RIGHT;
        }
        return deltaY < 0.0 ? ScrollDirection.DOWN : ScrollDirection.UP;
    }

    public static void addSmoothScrolling(ScrollPane scrollPane) {
        ScrollUtils.addSmoothScrolling(scrollPane, 1.0);
    }

    public static void addSmoothScrolling(ScrollPane scrollPane, double speed) {
        ScrollUtils.addSmoothScrolling(scrollPane, speed, 7.0);
    }

    public static void addSmoothScrolling(ScrollPane scrollPane, double speed, double trackPadAdjustment) {
        ScrollUtils.smoothScroll(scrollPane, speed, trackPadAdjustment);
    }

    private static void smoothScroll(ScrollPane scrollPane, double speed, double trackPadAdjustment) {
        double[] frictions = new double[]{0.99, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
        double[] derivatives = new double[frictions.length];
        AtomicReference<Double> atomicSpeed = new AtomicReference<Double>(speed);
        Timeline timeline = new Timeline();
        AtomicReference scrollDirection = new AtomicReference();
        EventHandler mouseHandler = event -> timeline.stop();
        EventHandler scrollHandler = event -> {
            if (event.getEventType() == ScrollEvent.SCROLL) {
                scrollDirection.set(ScrollUtils.determineScrollDirection(event));
                if (ScrollUtils.isTrackPad(event, (ScrollDirection)((Object)((Object)scrollDirection.get())))) {
                    atomicSpeed.set(speed / trackPadAdjustment);
                } else {
                    atomicSpeed.set(speed);
                }
                derivatives[0] = derivatives[0] + (double)((ScrollDirection)((Object)((Object)scrollDirection.get()))).intDirection * (Double)atomicSpeed.get();
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
                event.consume();
            }
        };
        if (scrollPane.getContent().getParent() != null) {
            scrollPane.getContent().getParent().addEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
            scrollPane.getContent().getParent().addEventHandler(ScrollEvent.ANY, scrollHandler);
        }
        scrollPane.getContent().parentProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
                oldValue.removeEventHandler(ScrollEvent.ANY, scrollHandler);
            }
            if (newValue != null) {
                newValue.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseHandler);
                newValue.addEventHandler(ScrollEvent.ANY, scrollHandler);
            }
        });
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), event -> {
            int i;
            for (i = 0; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] * frictions[i];
            }
            for (i = 1; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + derivatives[i - 1];
            }
            double dy = derivatives[derivatives.length - 1];
            Function<Bounds, Double> sizeFunction = scrollDirection.get() == ScrollDirection.UP || scrollDirection.get() == ScrollDirection.DOWN ? Bounds::getHeight : Bounds::getWidth;
            double size = sizeFunction.apply(scrollPane.getContent().getLayoutBounds());
            switch ((ScrollDirection)((Object)((Object)scrollDirection.get()))) {
                case LEFT: 
                case RIGHT: {
                    double value = Math.min(Math.max(scrollPane.hvalueProperty().get() + dy / size, 0.0), 1.0);
                    scrollPane.hvalueProperty().set(value);
                    break;
                }
                case UP: 
                case DOWN: {
                    double value = Math.min(Math.max(scrollPane.vvalueProperty().get() + dy / size, 0.0), 1.0);
                    scrollPane.vvalueProperty().set(value);
                }
            }
            if (Math.abs(dy) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    public static void animateScrollBars(ScrollPane scrollPane) {
        ScrollUtils.animateScrollBars(scrollPane, 500.0);
    }

    public static void animateScrollBars(ScrollPane scrollPane, double fadeSpeedMillis) {
        ScrollUtils.animateScrollBars(scrollPane, fadeSpeedMillis, 800.0);
    }

    public static void animateScrollBars(ScrollPane scrollPane, double fadeSpeedMillis, double hideAfterMillis) {
        NodeUtils.waitForSkin((Control)scrollPane, () -> {
            Set<ScrollBar> scrollBars = scrollPane.lookupAll(".scroll-bar").stream().filter(node -> node instanceof ScrollBar).map(node -> (ScrollBar)node).collect(Collectors.toSet());
            scrollBars.forEach(scrollBar -> {
                scrollBar.setOpacity(0.0);
                scrollPane.hoverProperty().addListener((observable, oldValue, newValue) -> {
                    if (!scrollBar.isVisible()) {
                        return;
                    }
                    if (newValue.booleanValue()) {
                        MFXAnimationFactory.FADE_IN.build((Node)scrollBar, fadeSpeedMillis).play();
                    } else {
                        AnimationUtils.PauseBuilder.build().setDuration(hideAfterMillis).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> MFXAnimationFactory.FADE_OUT.build((Node)scrollBar, fadeSpeedMillis).play())).getAnimation().play();
                    }
                });
            });
        }, true, true);
    }

    public static enum ScrollDirection {
        UP(-1),
        RIGHT(-1),
        DOWN(1),
        LEFT(1);

        final int intDirection;

        private ScrollDirection(int intDirection) {
            this.intDirection = intDirection;
        }

        public int intDirection() {
            return this.intDirection;
        }
    }
}

