/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.RandomUtils;
import java.util.Arrays;
import java.util.List;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static String difference(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        int at = StringUtils.indexOfDifference(str1, str2);
        if (at == -1) {
            return EMPTY;
        }
        return str2.substring(at);
    }

    public static int indexOfDifference(CharSequence cs1, CharSequence cs2) {
        int i;
        if (cs1 == cs2) {
            return -1;
        }
        if (cs1 == null || cs2 == null) {
            return 0;
        }
        for (i = 0; i < cs1.length() && i < cs2.length() && cs1.charAt(i) == cs2.charAt(i); ++i) {
        }
        if (i < cs2.length() || i < cs1.length()) {
            return i;
        }
        return -1;
    }

    public static String replaceLast(String string, String substring, String replacement) {
        int index = string.lastIndexOf(substring);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index) + replacement + string.substring(index + substring.length());
    }

    public static String replaceIndex(String string, int startIndex, int endIndex, String replacement) {
        StringBuilder sb = new StringBuilder(string);
        sb.replace(startIndex, endIndex, replacement);
        return sb.toString();
    }

    public static String titleCaseWord(String str) {
        int firstChar;
        if (((String)str).length() > 0 && !Character.isTitleCase(firstChar = ((String)str).codePointAt(0))) {
            str = new String(new int[]{Character.toTitleCase(firstChar)}, 0, 1) + ((String)str).substring(Character.offsetByCodePoints((CharSequence)str, 0, 1));
        }
        return str;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int max = str.length() - len;
        for (int i = 0; i <= max; ++i) {
            if (!StringUtils.regionMatches(str, i, searchStr, len)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }

    public static boolean containsAny(String str, String split, String ... words) {
        List<String> inputStringList = Arrays.asList(str.split(split));
        List<String> wordsList = Arrays.asList(words);
        return wordsList.stream().anyMatch(inputStringList::contains);
    }

    public static boolean containsAll(String str, String split, String ... words) {
        List<String> inputStringList = Arrays.asList(str.split(split));
        List<String> wordsList = Arrays.asList(words);
        return inputStringList.containsAll(wordsList);
    }

    public static String timeToHumanReadable(long elapsedSeconds) {
        if (elapsedSeconds < 60L) {
            return I18N.getOrDefault("stringUtil.now", new Object[0]);
        }
        long minutes = elapsedSeconds / 60L;
        if (minutes < 60L) {
            return I18N.getOrDefault("stringUtil.minutes", minutes);
        }
        long hours = minutes / 60L;
        return hours < 24L ? I18N.getOrDefault("stringUtils.hours", hours) : I18N.getOrDefault("stringUtils.days", hours / 24L);
    }

    public static String randAlphabetic(int length) {
        return RandomUtils.random.ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static String randAlphanumeric(int length) {
        return RandomUtils.random.ints(48, 123).filter(i -> !(i > 57 && i < 65 || i > 90 && i < 97)).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static boolean regionMatches(CharSequence cs, int thisStart, CharSequence substring, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(true, thisStart, (String)substring, 0, length);
        }
        int index1 = thisStart;
        int index2 = 0;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length();
        if (thisStart < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }
}

