/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.beans.SizeBean;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class TextUtils {
    private TextUtils() {
    }

    public static boolean isLabelTruncated(Label label) {
        String originalString = label.getText();
        Text textNode = (Text)label.lookup(".text");
        if (textNode != null) {
            String actualString = textNode.getText();
            return !actualString.isEmpty() && !originalString.equals(actualString);
        }
        return false;
    }

    public static void registerTruncatedLabelListener(BooleanProperty isTruncated, Label label) {
        label.needsLayoutProperty().addListener((observable, oldValue, newValue) -> {
            String originalString = label.getText();
            Text textNode = (Text)label.lookup(".text");
            String actualString = textNode.getText();
            isTruncated.set(!actualString.isEmpty() && !originalString.equals(actualString));
        });
    }

    public static double computeLabelWidth(Font font, String text) {
        Label helper = new Label(text);
        helper.setMaxWidth(Double.MAX_VALUE);
        helper.setFont(font);
        return NodeUtils.getRegionWidth((Region)helper);
    }

    public static double computeLabelHeight(Font font, String text) {
        Label helper = new Label(text);
        helper.setMaxWidth(Double.MAX_VALUE);
        helper.setFont(font);
        return NodeUtils.getRegionHeight((Region)helper);
    }

    public static SizeBean computeLabelSizes(Font font, String text) {
        Label helper = new Label(text);
        helper.setMaxWidth(Double.MAX_VALUE);
        helper.setFont(font);
        return NodeUtils.getNodeSizes((Node)helper);
    }

    public static double computeTextWidth(Font font, String text) {
        Text helper = new Text(text);
        helper.setFont(font);
        return NodeUtils.getNodeWidth((Node)helper);
    }

    public static double computeTextHeight(Font font, String text) {
        Text helper = new Text(text);
        helper.setFont(font);
        return NodeUtils.getNodeHeight((Node)helper);
    }

    public static double computeLabelWidth(Label label) {
        Node graphic = label.getGraphic();
        return label.snappedLeftInset() + (graphic != null ? graphic.getBoundsInParent().getWidth() : 0.0) + TextUtils.computeTextWidth(label.getFont(), label.getText()) + label.snappedRightInset() + label.getGraphicTextGap();
    }
}

