/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.utils.TreeItemIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TreeItemStream {
    public static <T> Stream<AbstractMFXTreeItem<T>> stream(AbstractMFXTreeItem<T> item) {
        return TreeItemStream.asStream(new TreeItemIterator<T>(item));
    }

    private static <T> Stream<AbstractMFXTreeItem<T>> asStream(TreeItemIterator<T> iterator) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<AbstractMFXTreeItem<T>> flattenTree(AbstractMFXTreeItem<T> item) {
        return Stream.concat(Stream.of(item), item.getItems().stream().flatMap(TreeItemStream::flattenTree));
    }
}

