/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others;

import java.util.function.Function;
import javafx.util.StringConverter;

@FunctionalInterface
public interface FunctionalStringConverter<T> {
    public T fromString(String var1);

    default public String toString(T t) {
        throw new UnsupportedOperationException();
    }

    public static <T> StringConverter<T> converter(final Function<String, T> fsFunction) {
        return new StringConverter<T>(){

            public String toString(T t) {
                throw new UnsupportedOperationException();
            }

            public T fromString(String string) {
                return fsFunction.apply(string);
            }
        };
    }

    public static <T> StringConverter<T> converter(final Function<String, T> fsFunction, final Function<T, String> tsFunction) {
        return new StringConverter<T>(){

            public String toString(T t) {
                return t != null ? (String)tsFunction.apply(t) : "";
            }

            public T fromString(String string) {
                return fsFunction.apply(string);
            }
        };
    }

    public static <T> StringConverter<T> from(final Function<String, T> fsFunction) {
        return new StringConverter<T>(){

            public String toString(T t) {
                throw new UnsupportedOperationException();
            }

            public T fromString(String string) {
                return fsFunction.apply(string);
            }
        };
    }

    public static <T> StringConverter<T> to(final Function<T, String> tsFunction) {
        return new StringConverter<T>(){

            public String toString(T t) {
                return (String)tsFunction.apply(t);
            }

            public T fromString(String string) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

