/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.dates;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javafx.util.StringConverter;

public class DateStringConverter
extends StringConverter<LocalDate> {
    private final DateTimeFormatter formatter;

    public DateStringConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public DateStringConverter(FormatStyle formatStyle) {
        this.formatter = DateTimeFormatter.ofLocalizedDate(formatStyle);
    }

    public DateStringConverter(String pattern, Locale locale) {
        this.formatter = DateTimeFormatter.ofPattern(pattern, locale);
    }

    public String toString(LocalDate date) {
        if (date == null) {
            return "";
        }
        return this.formatter.format(date);
    }

    public LocalDate fromString(String string) {
        if (string == null) {
            return null;
        }
        return LocalDate.parse(string, this.formatter);
    }
}

