/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.loader;

import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.enums.LoaderCacheLevel;
import io.github.palexdev.materialfx.utils.LoaderUtils;
import io.github.palexdev.materialfx.utils.others.loader.MFXLoaderBean;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.fxml.FXMLLoader;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class MFXLoader {
    private final Map<String, MFXLoaderBean> viewMap = new LinkedHashMap<String, MFXLoaderBean>();
    private final SupplierProperty<FXMLLoader> fxmlLoaderSupplier = new SupplierProperty<FXMLLoader>(FXMLLoader::new){

        public void set(Supplier<FXMLLoader> newValue) {
            if (newValue == null) {
                super.set(FXMLLoader::new);
                return;
            }
            super.set(newValue);
        }
    };
    private final AtomicInteger loadedCount = new AtomicInteger(0);
    private Consumer<List<MFXLoaderBean>> onLoadedAction;
    private LoaderCacheLevel cacheLevel = LoaderCacheLevel.SCENE_CACHE;

    public MFXLoader() {
        this(null);
    }

    public MFXLoader(Consumer<List<MFXLoaderBean>> onLoadedAction) {
        this.onLoadedAction = onLoadedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        List toLoad = this.viewMap.values().stream().filter(bean -> !bean.isLoaded()).collect(Collectors.toList());
        for (MFXLoaderBean bean2 : toLoad) {
            try {
                Callable<Parent> task = this.buildTask(bean2);
                Parent loaded = LoaderUtils.submit(task).get();
                this.cacheParent(loaded);
                bean2.setLoaded(true);
                this.loadedCount.addAndGet(1);
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
            finally {
                this.loadedCount.addAndGet(1);
            }
        }
        this.onLoaded(new ArrayList<MFXLoaderBean>(this.viewMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWith(ExecutorService executorService) {
        List toLoad = this.viewMap.values().stream().filter(bean -> !bean.isLoaded()).collect(Collectors.toList());
        for (MFXLoaderBean bean2 : toLoad) {
            try {
                Callable<Parent> task = this.buildTask(bean2);
                Parent loaded = executorService.submit(task).get();
                this.cacheParent(loaded);
                bean2.setLoaded(true);
                this.loadedCount.addAndGet(1);
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
            finally {
                this.loadedCount.addAndGet(1);
            }
        }
        this.onLoaded(new ArrayList<MFXLoaderBean>(this.viewMap.values()));
    }

    public MFXLoader addView(MFXLoaderBean bean) {
        LoaderUtils.checkFxmlFile(bean.getFxmlFile());
        this.viewMap.put(bean.getViewName(), bean);
        return this;
    }

    public MFXLoader addView(String viewName, URL fxmlFile) {
        LoaderUtils.checkFxmlFile(fxmlFile);
        this.viewMap.put(viewName, new MFXLoaderBean(viewName, fxmlFile));
        return this;
    }

    public MFXLoader addView(String viewName, URL fxmlFile, Callback<Class<?>, Object> controllerFactory) {
        LoaderUtils.checkFxmlFile(fxmlFile);
        this.viewMap.put(viewName, new MFXLoaderBean(viewName, fxmlFile, controllerFactory, false, null));
        return this;
    }

    public MFXLoaderBean getView(String viewName) {
        return this.viewMap.getOrDefault(viewName, null);
    }

    protected void onLoaded(List<MFXLoaderBean> beans) {
        if (this.onLoadedAction != null) {
            this.onLoadedAction.accept(beans);
        }
    }

    private Callable<Parent> buildTask(MFXLoaderBean bean) {
        ArrayList tasks = new ArrayList();
        return () -> {
            FXMLLoader loader = this.getFxmlLoaderSupplier().get();
            URL fxmlFile = bean.getFxmlFile();
            Callback<Class<?>, Object> controllerFactory = bean.getControllerFactory();
            loader.setLocation(fxmlFile);
            loader.setControllerFactory(controllerFactory);
            Parent root = (Parent)loader.load();
            bean.setRoot(root);
            return root;
        };
    }

    private void cacheParent(Parent parent) {
        if (this.cacheLevel == LoaderCacheLevel.NONE) {
            return;
        }
        if (this.cacheLevel == LoaderCacheLevel.SCENE_JAVAFX_CACHE) {
            parent.setCache(true);
            parent.setCacheHint(CacheHint.SPEED);
        }
        StackPane pane = new StackPane();
        pane.getChildren().setAll((Object[])new Node[]{parent});
        Scene scene = new Scene((Parent)pane);
        pane.applyCss();
        pane.layout();
    }

    public Supplier<FXMLLoader> getFxmlLoaderSupplier() {
        return (Supplier)this.fxmlLoaderSupplier.get();
    }

    public SupplierProperty<FXMLLoader> fxmlLoaderSupplierProperty() {
        return this.fxmlLoaderSupplier;
    }

    public MFXLoader setFxmlLoaderSupplier(Supplier<FXMLLoader> fxmlLoaderSupplier) {
        this.fxmlLoaderSupplier.set(fxmlLoaderSupplier);
        return this;
    }

    public Consumer<List<MFXLoaderBean>> getOnLoadedAction() {
        return this.onLoadedAction;
    }

    public MFXLoader setOnLoadedAction(Consumer<List<MFXLoaderBean>> onLoadedAction) {
        this.onLoadedAction = onLoadedAction;
        return this;
    }

    public LoaderCacheLevel getCacheLevel() {
        return this.cacheLevel;
    }

    public MFXLoader setCacheLevel(LoaderCacheLevel cacheLevel) {
        this.cacheLevel = cacheLevel;
        return this;
    }
}

