/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils.others.loader;

import java.net.URL;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Callback;

public class MFXLoaderBean {
    private final String viewName;
    private final URL fxmlFile;
    private Parent root;
    private Callback<Class<?>, Object> controllerFactory;
    private boolean defaultView = false;
    private boolean loaded = false;
    private Supplier<Node> beanToNodeMapper;

    public MFXLoaderBean(String viewName, URL fxmlFile) {
        this.viewName = viewName;
        this.fxmlFile = fxmlFile;
    }

    public MFXLoaderBean(String viewName, URL fxmlFile, Callback<Class<?>, Object> controllerFactory, boolean defaultView, Supplier<Node> beanToNodeMapper) {
        this.viewName = viewName;
        this.fxmlFile = fxmlFile;
        this.controllerFactory = controllerFactory;
        this.defaultView = defaultView;
        this.beanToNodeMapper = beanToNodeMapper;
    }

    public static Builder of(String viewName, URL fxmlFile) {
        return new Builder(viewName, fxmlFile);
    }

    public String getViewName() {
        return this.viewName;
    }

    public URL getFxmlFile() {
        return this.fxmlFile;
    }

    public Parent getRoot() {
        return this.root;
    }

    MFXLoaderBean setRoot(Parent root) {
        this.root = root;
        return this;
    }

    public Callback<Class<?>, Object> getControllerFactory() {
        return this.controllerFactory;
    }

    public MFXLoaderBean setControllerFactory(Callback<Class<?>, Object> controllerFactory) {
        this.controllerFactory = controllerFactory;
        return this;
    }

    public boolean isDefaultView() {
        return this.defaultView;
    }

    public MFXLoaderBean setDefaultView(boolean defaultView) {
        this.defaultView = defaultView;
        return this;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    MFXLoaderBean setLoaded(boolean loaded) {
        this.loaded = loaded;
        return this;
    }

    public Supplier<Node> getBeanToNodeMapper() {
        return this.beanToNodeMapper;
    }

    public MFXLoaderBean setBeanToNodeMapper(Supplier<Node> beanToNodeMapper) {
        this.beanToNodeMapper = beanToNodeMapper;
        return this;
    }

    public static class Builder {
        private final MFXLoaderBean bean;

        public Builder(String viewName, URL fxmlFile) {
            this.bean = new MFXLoaderBean(viewName, fxmlFile);
        }

        public Builder setControllerFactory(Callback<Class<?>, Object> controllerFactory) {
            this.bean.setControllerFactory(controllerFactory);
            return this;
        }

        public Builder setDefaultRoot(boolean defaultRoot) {
            this.bean.setDefaultView(defaultRoot);
            return this;
        }

        public Builder setBeanToNodeMapper(Supplier<Node> beanToNodeMapper) {
            this.bean.setBeanToNodeMapper(beanToNodeMapper);
            return this;
        }

        public MFXLoaderBean get() {
            return this.bean;
        }
    }
}

