/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.validation;

import io.github.palexdev.materialfx.enums.ChainMode;
import io.github.palexdev.materialfx.utils.others.observables.When;
import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.Severity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class MFXValidator {
    private final ObservableList<Constraint> constraints = FXCollections.observableArrayList();
    private final ObservableList<MFXValidator> dependencies = FXCollections.observableArrayList();
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(true);
    private BiConsumer<Boolean, List<Constraint>> onUpdated;
    private boolean sortBySeverity = true;
    private boolean failFast = false;

    public MFXValidator() {
        this.constraints.addListener(invalidated -> this.update());
        this.dependencies.addListener(invalidated -> this.update());
    }

    public MFXValidator constraint(Constraint constraint) {
        When.onInvalidated(constraint.getCondition()).then(value -> this.update()).listen();
        this.constraints.add((Object)constraint);
        return this;
    }

    public MFXValidator constraint(Severity severity, String message, BooleanExpression condition) {
        return this.constraint(Constraint.of(severity, message, condition));
    }

    public MFXValidator constraint(String message, BooleanExpression condition) {
        return this.constraint(Severity.ERROR, message, condition);
    }

    public MFXValidator removeConstraint(Constraint constraint) {
        if (this.constraints.remove((Object)constraint)) {
            When.disposeFor(constraint.getCondition());
        }
        return this;
    }

    public MFXValidator dependsOn(MFXValidator validator) {
        When.onInvalidated(validator.validProperty()).then(value -> this.update()).listen();
        this.dependencies.add((Object)validator);
        return this;
    }

    public MFXValidator removeDependency(MFXValidator validator) {
        if (this.dependencies.remove((Object)validator)) {
            When.disposeFor(validator.validProperty());
        }
        return this;
    }

    public List<Constraint> validate() {
        ArrayList<Constraint> invalidConstraints = new ArrayList<Constraint>();
        for (MFXValidator dependency : this.dependencies) {
            if (dependency.isValid()) continue;
            if (this.failFast) {
                return List.of(dependency.validate().get(0));
            }
            invalidConstraints.addAll(dependency.validate());
        }
        for (Constraint constraint : this.constraints) {
            if (constraint.isValid()) continue;
            invalidConstraints.add(constraint);
            if (!this.failFast) continue;
            return invalidConstraints;
        }
        if (this.sortBySeverity) {
            invalidConstraints.sort(Comparator.comparing(Constraint::getSeverity));
        }
        return invalidConstraints;
    }

    public void update() {
        boolean valid = true;
        for (MFXValidator dependency : this.dependencies) {
            valid = valid && dependency.isValid();
        }
        for (Constraint constraint : this.constraints) {
            valid = ChainMode.chain(constraint.getChainMode(), valid, constraint.isValid());
        }
        this.setValid(valid);
        this.onUpdated();
    }

    public String validateToString() {
        List<Constraint> invalidConstraints = this.validate();
        if (invalidConstraints.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        invalidConstraints.forEach(constraint -> sb.append(constraint.getMessage()).append("\n"));
        return sb.toString();
    }

    protected void onUpdated() {
        if (this.onUpdated != null) {
            this.onUpdated.accept(this.isValid(), this.validate());
        }
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    protected void setValid(boolean valid) {
        this.valid.set(valid);
    }

    public BiConsumer<Boolean, List<Constraint>> getOnUpdated() {
        return this.onUpdated;
    }

    public MFXValidator setOnUpdated(BiConsumer<Boolean, List<Constraint>> onUpdated) {
        this.onUpdated = onUpdated;
        return this;
    }

    public boolean isSortBySeverity() {
        return this.sortBySeverity;
    }

    public MFXValidator setSortBySeverity(boolean sortBySeverity) {
        this.sortBySeverity = sortBySeverity;
        return this;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public MFXValidator setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }
}

