/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.builders.base.INodeBuilder;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.mfxresources.fonts.IconDescriptor;
import io.github.palexdev.mfxresources.fonts.IconsProviders;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class IconBuilder
implements INodeBuilder<MFXFontIcon> {
    private final MFXFontIcon icon;

    public IconBuilder() {
        this.icon = new MFXFontIcon();
    }

    public IconBuilder(MFXFontIcon icon) {
        this.icon = icon;
    }

    public static IconBuilder icon() {
        return new IconBuilder();
    }

    public static IconBuilder icon(MFXFontIcon icon) {
        return new IconBuilder(icon);
    }

    public static MFXFontIcon getRandomIcon(IconsProviders provider, double size, Color color) {
        return provider.randomIcon(size, color);
    }

    public IconBuilder setColor(Color color) {
        this.icon.setColor(color);
        return this;
    }

    public IconBuilder setDescription(String code) {
        this.icon.setDescription(code);
        return this;
    }

    public IconBuilder setDescription(IconDescriptor descriptor) {
        this.icon.setDescription(descriptor.getDescription());
        return this;
    }

    public IconBuilder setSize(double size) {
        this.icon.setSize(size);
        return this;
    }

    public MFXIconWrapper wrapIcon(double size, boolean addRippleGenerator, boolean makeCircular) {
        MFXIconWrapper wrapped = new MFXIconWrapper((Node)this.icon, size);
        if (addRippleGenerator) {
            wrapped.defaultRippleGeneratorBehavior();
        }
        if (makeCircular) {
            NodeUtils.makeRegionCircular((Region)wrapped);
        }
        return wrapped;
    }

    @Override
    public MFXFontIcon getNode() {
        return null;
    }
}

