/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.controls.MFXPopup;
import java.util.function.BiFunction;
import javafx.animation.Animation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.transform.Scale;

public class PopupBuilder {
    private final MFXPopup popup;

    public PopupBuilder() {
        this(new MFXPopup());
    }

    public PopupBuilder(MFXPopup popup) {
        this.popup = popup;
    }

    public static PopupBuilder popup() {
        return new PopupBuilder();
    }

    public static PopupBuilder popup(MFXPopup popup) {
        return new PopupBuilder(popup);
    }

    public PopupBuilder show(Node ownerNode, double anchorX, double anchorY) {
        this.popup.show(ownerNode, anchorX, anchorY);
        return this;
    }

    public PopupBuilder show(Node node) {
        this.popup.show(node);
        return this;
    }

    public PopupBuilder show(Node node, Alignment alignment) {
        this.popup.show(node, alignment);
        return this;
    }

    public PopupBuilder show(Node node, Alignment alignment, double xOffset, double yOffset) {
        this.popup.show(node, alignment, xOffset, yOffset);
        return this;
    }

    public PopupBuilder setPopupStyleableParent(Parent parent) {
        this.popup.setPopupStyleableParent(parent);
        return this;
    }

    public PopupBuilder addStylesheet(String ... stylesheets) {
        this.popup.getStyleSheets().addAll((Object[])stylesheets);
        return this;
    }

    public PopupBuilder setStylesheet(String ... stylesheets) {
        this.popup.getStyleSheets().setAll((Object[])stylesheets);
        return this;
    }

    public PopupBuilder setContent(Node content) {
        this.popup.setContent(content);
        return this;
    }

    public PopupBuilder setAnimationProvider(BiFunction<Node, Scale, Animation> animationProvider) {
        this.popup.setAnimationProvider(animationProvider);
        return this;
    }

    public PopupBuilder setAnimated(boolean animated) {
        this.popup.setAnimated(animated);
        return this;
    }
}

