/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.builders.base.ControlBuilder;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTableRow;
import io.github.palexdev.materialfx.controls.MFXTableView;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.collections.ObservableList;

public class TableBuilder<T, V extends MFXTableView<T>>
extends ControlBuilder<V> {
    public TableBuilder() {
        this((V)new MFXTableView());
    }

    public TableBuilder(V tableView) {
        super(tableView);
    }

    public static <T> TableBuilder<T, MFXTableView<T>> table() {
        return new TableBuilder();
    }

    public static <T> TableBuilder<T, MFXTableView<T>> table(MFXTableView<T> tableView) {
        return new TableBuilder<T, MFXTableView<T>>(tableView);
    }

    public TableBuilder<T, V> autosizeColumnsOnInitialization() {
        ((MFXTableView)this.node).autosizeColumnsOnInitialization();
        return this;
    }

    public TableBuilder<T, V> scrollBy(double pixels) {
        ((MFXTableView)this.node).scrollBy(pixels);
        return this;
    }

    public TableBuilder<T, V> scrollTo(int index) {
        ((MFXTableView)this.node).scrollTo(index);
        return this;
    }

    public TableBuilder<T, V> scrollToFirst() {
        ((MFXTableView)this.node).scrollToFirst();
        return this;
    }

    public TableBuilder<T, V> scrollToLast() {
        ((MFXTableView)this.node).scrollToLast();
        return this;
    }

    public TableBuilder<T, V> scrollToPixel(double pixel) {
        ((MFXTableView)this.node).scrollToPixel(pixel);
        return this;
    }

    public TableBuilder<T, V> setHSpeed(double unit, double block) {
        ((MFXTableView)this.node).setHSpeed(unit, block);
        return this;
    }

    public TableBuilder<T, V> setVSpeed(double unit, double block) {
        ((MFXTableView)this.node).setVSpeed(unit, block);
        return this;
    }

    public TableBuilder<T, V> enableSmoothScrolling(double speed) {
        ((MFXTableView)this.node).features().enableSmoothScrolling(speed);
        return this;
    }

    public TableBuilder<T, V> enableSmoothScrolling(double speed, double trackPadAdjustment) {
        ((MFXTableView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment);
        return this;
    }

    public TableBuilder<T, V> enableSmoothScrolling(double speed, double trackPadAdjustment, double scrollThreshold) {
        ((MFXTableView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment, scrollThreshold);
        return this;
    }

    public TableBuilder<T, V> enableBounceEffect() {
        ((MFXTableView)this.node).features().enableBounceEffect();
        return this;
    }

    public TableBuilder<T, V> enableBounceEffect(double strength, double maxOverscroll) {
        ((MFXTableView)this.node).features().enableBounceEffect(strength, maxOverscroll);
        return this;
    }

    public TableBuilder<T, V> setItems(ObservableList<T> items) {
        ((MFXTableView)this.node).setItems(items);
        return this;
    }

    public TableBuilder<T, V> addColumns(MFXTableColumn<T> ... columns) {
        ((MFXTableView)this.node).getTableColumns().addAll(columns);
        return this;
    }

    public TableBuilder<T, V> setColumns(MFXTableColumn<T> ... columns) {
        ((MFXTableView)this.node).getTableColumns().setAll(columns);
        return this;
    }

    public TableBuilder<T, V> setTableRowFactory(Function<T, MFXTableRow<T>> tableRowFactory) {
        ((MFXTableView)this.node).setTableRowFactory(tableRowFactory);
        return this;
    }

    public TableBuilder<T, V> setFilter(Predicate<T> filter) {
        ((MFXTableView)this.node).getTransformableList().setPredicate(filter);
        return this;
    }

    public TableBuilder<T, V> setComparator(Comparator<T> comparator) {
        ((MFXTableView)this.node).getTransformableList().setComparator(comparator);
        return this;
    }

    public TableBuilder<T, V> setComparator(Comparator<T> comparator, boolean isReverse) {
        ((MFXTableView)this.node).getTransformableList().setComparator(comparator, isReverse);
        return this;
    }

    public TableBuilder<T, V> addFilters(AbstractFilter<T, ?> ... filters) {
        ((MFXTableView)this.node).getFilters().addAll((Object[])filters);
        return this;
    }

    public TableBuilder<T, V> setFilters(AbstractFilter<T, ?> ... filters) {
        ((MFXTableView)this.node).getFilters().setAll((Object[])filters);
        return this;
    }

    public TableBuilder<T, V> setFooterVisible(boolean footerVisible) {
        ((MFXTableView)this.node).setFooterVisible(footerVisible);
        return this;
    }
}

