/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ObservableStack<E>
extends SimpleListProperty<E> {
    private final LinkedList<E> stack = new LinkedList();

    public ObservableStack() {
        this.set(FXCollections.observableList(this.stack));
    }

    public E push(E item) {
        this.stack.push(item);
        this.fireValueChangedEvent(new StackChange(this.get(), ChangeType.PUSH.setChangedObj(Collections.singletonList(item))));
        return item;
    }

    public E pop() throws NoSuchElementException {
        E temp = this.stack.pop();
        this.fireValueChangedEvent(new StackChange(this.get(), ChangeType.POP.setChangedObj(Collections.singletonList(temp))));
        return temp;
    }

    public boolean add(E element) {
        this.push(element);
        return true;
    }

    public E remove(int i) throws IllegalArgumentException {
        if (0 == i) {
            return this.pop();
        }
        throw new IllegalArgumentException("Can only modify the top of the stack " + i);
    }

    public boolean removeAll() throws NoSuchElementException {
        this.get().remove(0, this.getSize());
        return true;
    }

    public void add(int i, E element) throws IllegalArgumentException {
        if (0 == i) {
            this.push(element);
        }
        throw new IllegalArgumentException("Can only modify the top of the stack " + i);
    }

    public boolean addAll(Collection<? extends E> elements) throws NullPointerException {
        elements.forEach(this.stack::push);
        this.fireValueChangedEvent(new StackChange(this.get(), ChangeType.PUSH.setChangedObj(new ArrayList<E>(elements))));
        return true;
    }

    public boolean addAll(E ... elements) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elements));
    }

    public boolean addAll(int i, Collection<? extends E> elements) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not allowed, use pop");
    }

    public void remove(int from, int to) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not allowed, use pop");
    }

    public boolean removeAll(E ... elements) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    private final class StackChange
    extends ListChangeListener.Change<E> {
        private final ChangeType type;
        private boolean onChange;

        public StackChange(ObservableList<E> list, ChangeType type) {
            super(list);
            this.type = type;
            this.onChange = false;
        }

        public boolean wasAdded() {
            return this.type == ChangeType.PUSH;
        }

        public boolean wasRemoved() {
            return this.type == ChangeType.POP;
        }

        public boolean next() {
            if (this.onChange) {
                return false;
            }
            this.onChange = true;
            return true;
        }

        public void reset() {
            this.onChange = false;
        }

        public int getFrom() {
            if (!this.onChange) {
                throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
            }
            return 0;
        }

        public int getTo() {
            if (!this.onChange) {
                throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
            }
            return this.type.getChangedObj().size();
        }

        public List<E> getRemoved() {
            return this.wasRemoved() ? this.type.getChangedObj() : Collections.emptyList();
        }

        protected int[] getPermutation() {
            return new int[0];
        }
    }

    private static enum ChangeType {
        PUSH,
        POP;

        private List changedObj;

        public List getChangedObj() {
            return this.changedObj;
        }

        public ChangeType setChangedObj(List obj) {
            this.changedObj = obj;
            return this;
        }
    }
}

