/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.AbstractMFXListView;
import io.github.palexdev.materialfx.controls.cell.MFXCheckListCell;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.skins.MFXListViewSkin;
import io.github.palexdev.materialfx.utils.ListChangeHelper;
import io.github.palexdev.materialfx.utils.ListChangeProcessor;
import io.github.palexdev.mfxcore.base.TriConsumer;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.control.Skin;

public class MFXCheckListView<T>
extends AbstractMFXListView<T, MFXCheckListCell<T>> {
    private final String STYLE_CLASS = "mfx-check-list-view";
    private final SimpleVirtualFlow<T, MFXCheckListCell<T>> virtualFlow;
    private final ListChangeListener<? super T> itemsChanged = this::itemsChanged;

    public MFXCheckListView() {
        this.virtualFlow = new SimpleVirtualFlow(this.itemsProperty(), null, Orientation.VERTICAL);
        this.initialize();
    }

    public MFXCheckListView(ObservableList<T> items) {
        super(items);
        this.virtualFlow = new SimpleVirtualFlow(this.itemsProperty(), null, Orientation.VERTICAL);
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getStyleClass().add((Object)"mfx-check-list-view");
        this.items.addListener((observable, oldValue, newValue) -> {
            oldValue.removeListener(this.itemsChanged);
            newValue.addListener(this.itemsChanged);
        });
        this.getItems().addListener(this::itemsChanged);
    }

    protected void itemsChanged(ListChangeListener.Change<? extends T> change) {
        if (this.getSelectionModel().getSelection().isEmpty()) {
            return;
        }
        if (change.getList().isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        ListChangeHelper.Change c = ListChangeHelper.processChange(change, IntegerRange.of((Integer)0, (Integer)Integer.MAX_VALUE));
        ListChangeProcessor updater = new ListChangeProcessor(new HashSet<Integer>(this.getSelectionModel().getSelection().keySet()));
        c.processReplacement((changed, removed) -> this.getSelectionModel().replaceSelection(changed.toArray(new Integer[0])));
        c.processAddition((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, added) -> {
            updater.computeAddition(added.size(), (int)from);
            this.getSelectionModel().replaceSelection(updater.getIndexes().toArray(new Integer[0]));
        }));
        c.processRemoval((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, removed) -> {
            updater.computeRemoval((Set<Integer>)removed, (int)from);
            this.getSelectionModel().replaceSelection(updater.getIndexes().toArray(new Integer[0]));
        }));
    }

    public MFXCheckListCell<T> getCell(int index) {
        return (MFXCheckListCell)this.virtualFlow.getCell(index);
    }

    public Map<Integer, MFXCheckListCell<T>> getCells() {
        return this.virtualFlow.getCells();
    }

    public void scrollBy(double pixels) {
        this.virtualFlow.scrollBy(pixels);
    }

    public void scrollTo(int index) {
        this.virtualFlow.scrollTo(index);
    }

    public void scrollToFirst() {
        this.virtualFlow.scrollToFirst();
    }

    public void scrollToLast() {
        this.virtualFlow.scrollToLast();
    }

    public void scrollToPixel(double pixel) {
        this.virtualFlow.scrollToPixel(pixel);
    }

    public void setHSpeed(double unit, double block) {
        this.virtualFlow.setHSpeed(unit, block);
    }

    public void setVSpeed(double unit, double block) {
        this.virtualFlow.setVSpeed(unit, block);
    }

    public double getVerticalPosition() {
        return this.virtualFlow.getVerticalPosition();
    }

    public double getHorizontalPosition() {
        return this.virtualFlow.getHorizontalPosition();
    }

    public SimpleVirtualFlow.Features features() {
        return this.virtualFlow.features();
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.CHECK_LIST_VIEW;
    }

    @Override
    protected void setDefaultCellFactory() {
        this.setCellFactory((Function<T, MFXCheckListCell<T>>)((Function<Object, MFXCheckListCell>)item -> new MFXCheckListCell<Object>(this, item)));
    }

    @Override
    public Function<T, MFXCheckListCell<T>> getCellFactory() {
        return this.virtualFlow.getCellFactory();
    }

    @Override
    public ObjectProperty<Function<T, MFXCheckListCell<T>>> cellFactoryProperty() {
        return this.virtualFlow.cellFactoryProperty();
    }

    @Override
    public void setCellFactory(Function<T, MFXCheckListCell<T>> cellFactory) {
        this.virtualFlow.setCellFactory(cellFactory);
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXListViewSkin<T>(this, this.virtualFlow);
    }
}

