/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.AbstractMFXToggleNode;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.enums.TextPosition;
import io.github.palexdev.materialfx.skins.MFXCircleToggleNodeSkin;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;

public class MFXCircleToggleNode
extends AbstractMFXToggleNode {
    private final String STYLE_CLASS = "mfx-circle-toggle-node";
    private final StyleableDoubleProperty gap = new SimpleStyleableDoubleProperty(StyleableProperties.GAP, (Object)this, "gap", Double.valueOf(5.0));
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", Double.valueOf(32.0));
    private final StyleableObjectProperty<TextPosition> textPosition = new SimpleStyleableObjectProperty(StyleableProperties.TEXT_POSITION, (Object)this, "textPosition", (Object)TextPosition.BOTTOM);

    public MFXCircleToggleNode() {
        this("");
    }

    public MFXCircleToggleNode(String text) {
        this(text, null);
    }

    public MFXCircleToggleNode(String text, Node icon) {
        this(text, icon, null, null);
    }

    public MFXCircleToggleNode(String text, Node icon, Node leadingIcon, Node trailingIcon) {
        super(text, icon);
        this.setLabelLeadingIcon(leadingIcon);
        this.setLabelTrailingIcon(trailingIcon);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-circle-toggle-node");
    }

    public double getGap() {
        return this.gap.get();
    }

    public StyleableDoubleProperty gapProperty() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap.set(gap);
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public TextPosition getTextPosition() {
        return (TextPosition)((Object)this.textPosition.get());
    }

    public StyleableObjectProperty<TextPosition> textPositionProperty() {
        return this.textPosition;
    }

    public void setTextPosition(TextPosition textPosition) {
        this.textPosition.set((Object)textPosition);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.CIRCLE_TOGGLE_NODE;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXCircleToggleNodeSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXCircleToggleNode.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXCircleToggleNode> FACTORY = new StyleablePropertyFactory(ToggleButton.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXCircleToggleNode, Number> GAP;
        private static final CssMetaData<MFXCircleToggleNode, Number> SIZE;
        private static final CssMetaData<MFXCircleToggleNode, TextPosition> TEXT_POSITION;

        private StyleableProperties() {
        }

        static {
            GAP = FACTORY.createSizeCssMetaData("-mfx-gap", MFXCircleToggleNode::gapProperty, (Number)5.0);
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXCircleToggleNode::sizeProperty, (Number)32.0);
            TEXT_POSITION = FACTORY.createEnumCssMetaData(TextPosition.class, "-mfx-text-position", MFXCircleToggleNode::textPositionProperty, (Enum)TextPosition.BOTTOM);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(ToggleButton.getClassCssMetaData(), GAP, SIZE, TEXT_POSITION);
        }
    }
}

