/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.functional.ConsumerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.skins.MFXContextMenuSkin;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;

public class MFXContextMenu
extends MFXPopup {
    private final String STYLE_CLASS = "mfx-context-menu";
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private Node owner;
    private EventHandler<MouseEvent> ownerHandler;
    private boolean disabled = false;
    private final FunctionProperty<MouseEvent, Boolean> showCondition = new FunctionProperty<MouseEvent, Boolean>(event -> !this.disabled && event.getButton() == MouseButton.SECONDARY);
    private final ConsumerProperty<MouseEvent> showAction = new ConsumerProperty<MouseEvent>(event -> this.show(this.owner, event.getScreenX(), event.getScreenY()));

    public MFXContextMenu(Node owner) {
        if (owner == null) {
            throw new NullPointerException("Owner node cannot be null!");
        }
        this.owner = owner;
        this.ownerHandler = event -> {
            if (this.isShowing()) {
                this.hide();
                return;
            }
            if (this.getShowCondition().apply((MouseEvent)event).booleanValue()) {
                this.getShowAction().accept((MouseEvent)event);
            }
        };
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-context-menu");
    }

    public void install() {
        this.owner.addEventFilter(MouseEvent.MOUSE_CLICKED, this.ownerHandler);
    }

    public void uninstall() {
        this.owner.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.ownerHandler);
    }

    public void dispose() {
        if (this.owner != null) {
            this.uninstall();
            this.ownerHandler = null;
            this.owner = null;
        }
    }

    public void addItem(MFXContextMenuItem item) {
        this.items.add((Object)item);
    }

    public void addItems(MFXContextMenuItem ... items) {
        this.items.addAll((Object[])items);
    }

    public void addSeparator(Node separator) {
        separator.getStyleClass().add((Object)"separator");
        this.items.add((Object)separator);
    }

    public void addLineSeparator(Line separator) {
        separator.getStyleClass().add((Object)"line-separator");
        this.items.add((Object)separator);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXContextMenuSkin(this);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    public Node getOwner() {
        return this.owner;
    }

    public Function<MouseEvent, Boolean> getShowCondition() {
        return (Function)this.showCondition.get();
    }

    public FunctionProperty<MouseEvent, Boolean> showConditionProperty() {
        return this.showCondition;
    }

    public void setShowCondition(Function<MouseEvent, Boolean> showCondition) {
        this.showCondition.set(showCondition);
    }

    public Consumer<MouseEvent> getShowAction() {
        return (Consumer)this.showAction.get();
    }

    public ConsumerProperty<MouseEvent> showActionProperty() {
        return this.showAction;
    }

    public void setShowAction(Consumer<MouseEvent> showAction) {
        this.showAction.set(showAction);
    }

    public static class Builder {
        private final MFXContextMenu contextMenu;

        private Builder(Node owner) {
            this.contextMenu = new MFXContextMenu(owner);
        }

        public static Builder build(Node owner) {
            return new Builder(owner);
        }

        public Builder addItem(MFXContextMenuItem item) {
            this.contextMenu.addItem(item);
            return this;
        }

        public Builder addItems(MFXContextMenuItem ... items) {
            this.contextMenu.addItems(items);
            return this;
        }

        public Builder addItem(MFXContextMenuItem item, EventHandler<ActionEvent> action) {
            item.setOnAction(action);
            this.contextMenu.addItem(item);
            return this;
        }

        public Builder addSeparator(Node node) {
            this.contextMenu.addSeparator(node);
            return this;
        }

        public Builder addLineSeparator() {
            this.contextMenu.addLineSeparator(Builder.getLineSeparator());
            return this;
        }

        public Builder addLineSeparator(Insets insets) {
            this.contextMenu.addLineSeparator(Builder.getLineSeparator(insets));
            return this;
        }

        public Builder setShowCondition(Function<MouseEvent, Boolean> showCondition) {
            this.contextMenu.setShowCondition(showCondition);
            return this;
        }

        public Builder setShowAction(Consumer<MouseEvent> showAction) {
            this.contextMenu.setShowAction(showAction);
            return this;
        }

        public Builder setPopupStyleableParent(Parent parent) {
            this.contextMenu.setPopupStyleableParent(parent);
            return this;
        }

        public MFXContextMenu get() {
            return this.contextMenu;
        }

        public MFXContextMenu installAndGet() {
            this.contextMenu.install();
            return this.contextMenu;
        }

        public static Line getLineSeparator() {
            return Builder.getLineSeparator(InsetsFactory.of(4.0, 0.0, 4.0, 0.0));
        }

        public static Line getLineSeparator(Insets insets) {
            Line separator = new Line();
            separator.setStartX(0.0);
            VBox.setMargin((Node)separator, (Insets)InsetsFactory.of(4.0, 0.0, 4.0, 0.0));
            return separator;
        }
    }
}

