/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableStringProperty;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class MFXPasswordField
extends MFXTextField {
    private final String STYLE_CLASS = "mfx-password-field";
    public static final String BULLET = "\u25cf";
    protected static final PseudoClass MASKED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"masked");
    private final StyleableBooleanProperty allowCopy = new StyleableBooleanProperty(StyleableProperties.ALLOW_COPY, this, "allowCopy", false);
    private final StyleableBooleanProperty allowCut = new StyleableBooleanProperty(StyleableProperties.ALLOW_CUT, this, "allowCut", false);
    private final StyleableBooleanProperty allowPaste = new StyleableBooleanProperty(StyleableProperties.ALLOW_PASTE, this, "allowPaste", false);
    private final StyleableBooleanProperty showPassword = new StyleableBooleanProperty(StyleableProperties.SHOW_PASSWORD, this, "showPassword", false);
    private final StyleableStringProperty hideCharacter = new StyleableStringProperty(StyleableProperties.HIDE_CHARACTER, this, "hideCharacter", "\u25cf"){

        public void set(String newValue) {
            if (newValue.trim().isEmpty()) {
                return;
            }
            super.set(newValue.length() > 1 ? newValue.substring(0, 1) : newValue);
        }
    };

    public MFXPasswordField() {
        this("");
    }

    public MFXPasswordField(String text) {
        this(text, "");
    }

    public MFXPasswordField(String text, String promptText) {
        this(text, promptText, "");
    }

    public MFXPasswordField(String text, String promptText, String floatingText) {
        super(text, promptText, floatingText);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-password-field");
        this.setBehavior();
        this.defaultTrailingIcon();
        this.defaultContextMenu();
    }

    protected void setBehavior() {
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getClickCount() >= 2 && event.getClickCount() % 2 == 0) {
                this.selectAll();
                event.consume();
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case LEFT: 
                case RIGHT: {
                    if (!event.isControlDown() || !event.isShiftDown()) break;
                    this.boundField.selectAll();
                    event.consume();
                }
            }
        });
        if (!this.isShowPassword()) {
            this.pseudoClassStateChanged(MASKED_PSEUDO_CLASS, true);
        }
        this.showPassword.addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(MASKED_PSEUDO_CLASS, newValue == false));
    }

    protected void defaultTrailingIcon() {
        MFXFontIcon icon = new MFXFontIcon("fas-eye", 16.0, Color.web((String)"#4D4D4D"));
        icon.getStyleClass().add((Object)"eye-icon");
        icon.descriptionProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.isShowPassword() ? "fas-eye-slash" : "fas-eye", (Observable[])new Observable[]{this.showPasswordProperty()}));
        MFXIconWrapper showPasswordIcon = new MFXIconWrapper((Node)icon, 24.0).defaultRippleGeneratorBehavior();
        NodeUtils.makeRegionCircular((Region)showPasswordIcon);
        showPasswordIcon.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.setShowPassword(!this.isShowPassword());
            int currPos = this.delegateGetCaretPosition();
            this.positionCaret(0);
            this.positionCaret(currPos);
            event.consume();
        });
        this.setTrailingIcon((Node)showPasswordIcon);
    }

    @Override
    public void defaultContextMenu() {
        if (this.allowCopy == null || this.allowCut == null || this.allowPaste == null) {
            return;
        }
        MFXContextMenuItem copyItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-copy", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.copy", new Object[0])).setAccelerator("Ctrl + C").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.copy())).get();
        copyItem.disableProperty().bind((ObservableValue)this.allowCopyProperty().not());
        MFXContextMenuItem cutItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-scissors", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.cut", new Object[0])).setAccelerator("Ctrl + X").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.cut())).get();
        cutItem.disableProperty().bind((ObservableValue)this.allowCutProperty().not());
        MFXContextMenuItem pasteItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-paste", 14.0)).setText(I18N.getOrDefault("textField.contextMenu.paste", new Object[0])).setAccelerator("Ctrl + V").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.paste())).get();
        pasteItem.disableProperty().bind((ObservableValue)this.allowPasteProperty().not());
        MFXContextMenuItem deleteItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-delete-left", 16.0)).setText(I18N.getOrDefault("textField.contextMenu.delete", new Object[0])).setAccelerator("Ctrl + D").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.boundField.deleteText(this.delegateGetSelection()))).get();
        MFXContextMenuItem selectAllItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-check-double", 16.0)).setText(I18N.getOrDefault("textField.contextMenu.selectAll", new Object[0])).setAccelerator("Ctrl + A").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectAll())).get();
        MFXContextMenuItem redoItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-arrow-rotate-right", 12.0)).setText(I18N.getOrDefault("textField.contextMenu.redo", new Object[0])).setAccelerator("Ctrl + Y").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.boundField.redo())).get();
        redoItem.disableProperty().bind((ObservableValue)this.delegateRedoableProperty().not());
        MFXContextMenuItem undoItem = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("fas-arrow-rotate-left", 12.0)).setText(I18N.getOrDefault("textField.contextMenu.undo", new Object[0])).setAccelerator("Ctrl + Z").setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.boundField.undo())).get();
        undoItem.disableProperty().bind((ObservableValue)this.delegateUndoableProperty().not());
        this.contextMenu = MFXContextMenu.Builder.build((Node)this).addItems(copyItem, cutItem, pasteItem, deleteItem, selectAllItem).addLineSeparator().addItems(redoItem, undoItem).setPopupStyleableParent((Parent)this).installAndGet();
    }

    @Override
    public void copy() {
        if (!this.isAllowCopy()) {
            return;
        }
        super.copy();
    }

    @Override
    public void cut() {
        if (!this.isAllowCut()) {
            return;
        }
        super.cut();
    }

    @Override
    public void paste() {
        if (!this.isAllowPaste()) {
            return;
        }
        super.paste();
    }

    @Override
    public void previousWord() {
        this.boundField.selectAll();
    }

    @Override
    public void nextWord() {
        this.boundField.selectAll();
    }

    @Override
    public void endOfNextWord() {
        this.boundField.selectAll();
    }

    @Override
    public void selectPreviousWord() {
        this.boundField.selectAll();
    }

    @Override
    public void selectNextWord() {
        this.boundField.selectAll();
    }

    @Override
    public void selectEndOfNextWord() {
        this.boundField.selectAll();
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.PASSWORD_FIELD;
    }

    public boolean isAllowCopy() {
        return this.allowCopy.get();
    }

    public StyleableBooleanProperty allowCopyProperty() {
        return this.allowCopy;
    }

    public void setAllowCopy(boolean allowCopy) {
        this.allowCopy.set(allowCopy);
    }

    public boolean isAllowCut() {
        return this.allowCut.get();
    }

    public StyleableBooleanProperty allowCutProperty() {
        return this.allowCut;
    }

    public void setAllowCut(boolean allowCut) {
        this.allowCut.set(allowCut);
    }

    public boolean isAllowPaste() {
        return this.allowPaste.get();
    }

    public StyleableBooleanProperty allowPasteProperty() {
        return this.allowPaste;
    }

    public void setAllowPaste(boolean allowPaste) {
        this.allowPaste.set(allowPaste);
    }

    public boolean isShowPassword() {
        return this.showPassword.get();
    }

    public StyleableBooleanProperty showPasswordProperty() {
        return this.showPassword;
    }

    public void setShowPassword(boolean showPassword) {
        this.showPassword.set(showPassword);
    }

    public String getHideCharacter() {
        return this.hideCharacter.get();
    }

    public StyleableStringProperty hideCharacterProperty() {
        return this.hideCharacter;
    }

    public void setHideCharacter(String hideCharacter) {
        this.hideCharacter.set(hideCharacter);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXPasswordField.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXPasswordField> FACTORY = new StyleablePropertyFactory(MFXTextField.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXPasswordField, Boolean> ALLOW_COPY;
        private static final CssMetaData<MFXPasswordField, Boolean> ALLOW_CUT;
        private static final CssMetaData<MFXPasswordField, Boolean> ALLOW_PASTE;
        private static final CssMetaData<MFXPasswordField, Boolean> SHOW_PASSWORD;
        private static final CssMetaData<MFXPasswordField, String> HIDE_CHARACTER;

        private StyleableProperties() {
        }

        static {
            ALLOW_COPY = FACTORY.createBooleanCssMetaData("-mfx-allow-copy", MFXPasswordField::allowCopyProperty, false);
            ALLOW_CUT = FACTORY.createBooleanCssMetaData("-mfx-allow-cut", MFXPasswordField::allowCutProperty, false);
            ALLOW_PASTE = FACTORY.createBooleanCssMetaData("-mfx-allow-paste", MFXPasswordField::allowPasteProperty, false);
            SHOW_PASSWORD = FACTORY.createBooleanCssMetaData("-mfx-show-password", MFXPasswordField::showPasswordProperty, false);
            HIDE_CHARACTER = FACTORY.createStringCssMetaData("-mfx-hide-character", MFXPasswordField::hideCharacterProperty, MFXPasswordField.BULLET);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(MFXTextField.getClassCssMetaData(), ALLOW_COPY, ALLOW_CUT, ALLOW_PASTE, SHOW_PASSWORD, HIDE_CHARACTER);
        }
    }
}

