/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.beans.PopupPositionBean;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.css.MFXCSSBridge;
import io.github.palexdev.materialfx.css.MFXStyleablePopup;
import io.github.palexdev.materialfx.css.themes.MFXThemeManager;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.css.themes.Themes;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.skins.MFXPopupSkin;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import javafx.animation.Animation;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Scale;
import javafx.stage.Screen;
import javafx.stage.Window;

public class MFXPopup
extends PopupControl
implements MFXStyleablePopup {
    private static final WeakHashMap<MFXPopup, Boolean> configMap = new WeakHashMap();
    private PopupPositionBean position;
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(){

        public void set(Node newValue) {
            Node oldValue = (Node)this.get();
            if (oldValue != null) {
                oldValue.removeEventFilter(MouseEvent.MOUSE_ENTERED, MFXPopup.this.entered);
                oldValue.removeEventFilter(MouseEvent.MOUSE_EXITED, MFXPopup.this.exited);
            }
            newValue.addEventFilter(MouseEvent.MOUSE_ENTERED, MFXPopup.this.entered);
            newValue.addEventFilter(MouseEvent.MOUSE_EXITED, MFXPopup.this.exited);
            super.set((Object)newValue);
        }
    };
    private BiFunction<Node, Scale, Animation> animationProvider;
    private boolean animated = true;
    private final PseudoClass HOVER_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"popup-hover");
    private final ReadOnlyBooleanWrapper hover = new ReadOnlyBooleanWrapper(false);
    private final EventHandler<MouseEvent> entered = event -> this.setHover(true);
    private final EventHandler<MouseEvent> exited = event -> this.setHover(false);
    private final MFXCSSBridge bridge = new MFXCSSBridge(null);

    public MFXPopup() {
        this.animationProvider = (node, scale) -> AnimationUtils.TimelineBuilder.build().show(150.0, (Node)node).add(AnimationUtils.KeyFrames.of(150.0, scale.xProperty(), Integer.valueOf(1), Interpolators.INTERPOLATOR_V2)).add(AnimationUtils.KeyFrames.of(150.0, scale.yProperty(), Integer.valueOf(1), Interpolators.INTERPOLATOR_V2)).getAnimation();
        this.initialize();
    }

    public MFXPopup(Node content) {
        this.setContent(content);
        this.animationProvider = (node, scale) -> AnimationUtils.TimelineBuilder.build().show(150.0, (Node)node).add(AnimationUtils.KeyFrames.of(150.0, scale.xProperty(), Integer.valueOf(1), Interpolators.INTERPOLATOR_V2)).add(AnimationUtils.KeyFrames.of(150.0, scale.yProperty(), Integer.valueOf(1), Interpolators.INTERPOLATOR_V2)).getAnimation();
        this.initialize();
    }

    private void initialize() {
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        MFXThemeManager.addOn((MFXPopup)this, (Theme[])new Themes[]{Themes.DEFAULT, Themes.LEGACY});
        this.hover.addListener(invalidated -> this.pseudoClassStateChanged(this.HOVER_PSEUDO_CLASS, this.hover.get()));
    }

    public void show(Node ownerNode, double anchorX, double anchorY) {
        this.position = new PopupPositionBean(ownerNode, PositionBean.of(anchorX, anchorY), null, 0.0, 0.0);
        super.show(ownerNode, anchorX, anchorY);
    }

    public void show(Node node) {
        this.show(node, Alignment.of(HPos.RIGHT, VPos.BOTTOM), 0.0, 0.0);
    }

    public void show(Node node, Alignment alignment) {
        this.show(node, alignment, 0.0, 0.0);
    }

    public void show(Node node, Alignment alignment, double xOffset, double yOffset) {
        if (node.getScene() == null || node.getScene().getWindow() == null) {
            throw new IllegalStateException("Cannot show the popup. The node must be attached to a scene/window!");
        }
        Window window = node.getScene().getWindow();
        PositionBean position = this.computePosition(node, window, alignment, xOffset, yOffset);
        this.position = new PopupPositionBean(node, position, alignment, xOffset, yOffset);
        this.show(window, position.getX(), position.getY());
    }

    public void reposition() {
        if (!this.isShowing() || this.position == null) {
            return;
        }
        this.position = this.computePosition();
        double x = this.position.getX();
        double y = this.position.getY();
        if (MFXPopup.isFixPosition(this)) {
            double contentWith = this.getContent().prefWidth(-1.0);
            double contentHeight = this.getContent().prefHeight(-1.0);
            double endX = x + contentWith;
            double endY = y + contentHeight;
            Screen nodeScreen = NodeUtils.getScreenFor(this.position.getOwner());
            if (nodeScreen != null) {
                Rectangle2D screenBounds = nodeScreen.getBounds();
                if (endX > screenBounds.getMaxX()) {
                    x -= endX - screenBounds.getMaxX();
                }
                if (endY > screenBounds.getMaxY()) {
                    y -= endY - screenBounds.getMaxY();
                }
            }
            this.position.setX(x);
            this.position.setY(y);
        }
        this.setX(this.position.getX());
        this.setY(this.position.getY());
    }

    private PositionBean computePosition(Node node, Window window, Alignment alignment, double xOffset, double yOffset) {
        Point2D origin = node.localToScene(0.0, 0.0);
        if (alignment != null) {
            HPos hPos = alignment.getHPos();
            VPos vPos = alignment.getVPos();
            double x = window.getX() + origin.getX() + node.getScene().getX() + this.computeHPos(node, hPos, xOffset);
            double y = window.getY() + origin.getY() + node.getScene().getY() + this.computeVPos(node, vPos, yOffset);
            return PositionBean.of(x, y);
        }
        return this.position != null ? this.position.getPositionBean() : PositionBean.of(0.0, 0.0);
    }

    public PopupPositionBean computePosition() {
        Node node = this.position.getOwner();
        Window window = node.getScene().getWindow();
        Alignment alignment = this.position.getAlignment();
        PositionBean reposition = this.computePosition(node, window, alignment, this.position.getXOffset(), this.position.getYOffset());
        return new PopupPositionBean(node, reposition, alignment, this.position.getXOffset(), this.position.getYOffset());
    }

    private double computeHPos(Node node, HPos hPos, double xOffset) {
        double x;
        double contentWidth = this.getContent().prefWidth(-1.0);
        double ownerWidth = node.getLayoutBounds().getWidth();
        switch (hPos) {
            case LEFT: {
                x = -Math.abs(contentWidth - ownerWidth);
                break;
            }
            case CENTER: {
                x = -Math.abs(ownerWidth / 2.0 - contentWidth / 2.0);
                break;
            }
            default: {
                x = 0.0;
            }
        }
        return x + xOffset;
    }

    private double computeVPos(Node node, VPos vPos, double yOffset) {
        return (vPos == VPos.BOTTOM ? node.getLayoutBounds().getHeight() : 0.0) + yOffset;
    }

    public void hide() {
        this.position = null;
        super.hide();
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXPopupSkin(this);
    }

    @Override
    public Parent getPopupStyleableParent() {
        return this.bridge.getParent();
    }

    @Override
    public void setPopupStyleableParent(Parent parent) {
        this.bridge.dispose();
        this.bridge.setParent(parent);
        this.bridge.initializeStylesheets();
    }

    public Styleable getStyleableParent() {
        if (this.bridge != null && this.bridge.getParent() != null) {
            return this.bridge.getParent();
        }
        return super.getStyleableParent();
    }

    @Override
    public ObservableList<String> getStyleSheets() {
        return this.bridge.getStylesheets();
    }

    public static void fixPosition(MFXPopup popup, boolean fix) {
        configMap.put(popup, fix);
    }

    public static boolean isFixPosition(MFXPopup popup) {
        return configMap.getOrDefault(popup, false);
    }

    public PopupPositionBean getPosition() {
        return this.position;
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public BiFunction<Node, Scale, Animation> getAnimationProvider() {
        return this.animationProvider;
    }

    public void setAnimationProvider(BiFunction<Node, Scale, Animation> animationProvider) {
        this.animationProvider = animationProvider;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isHover() {
        return this.hover.get();
    }

    public ReadOnlyBooleanProperty hoverProperty() {
        return this.hover.getReadOnlyProperty();
    }

    protected void setHover(boolean hover) {
        this.hover.set(hover);
    }

    public static class MFXPopupEvent
    extends Event {
        public static final EventType<MFXPopupEvent> REPOSITION_EVENT = new EventType(ANY, "Reposition Event");

        public MFXPopupEvent(EventType<? extends Event> eventType) {
            super(eventType);
        }
    }
}

