/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.skins.MFXScrollPaneSkin;
import io.github.palexdev.materialfx.utils.ColorUtils;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXScrollPane
extends ScrollPane
implements Themable {
    private final String STYLE_CLASS = "mfx-scroll-pane";
    private final ObjectProperty<Paint> trackColor = new SimpleObjectProperty((Object)Color.rgb((int)132, (int)132, (int)132));
    private final ObjectProperty<Paint> thumbColor = new SimpleObjectProperty((Object)Color.rgb((int)137, (int)137, (int)137));
    private final ObjectProperty<Paint> thumbHoverColor = new SimpleObjectProperty((Object)Color.rgb((int)89, (int)88, (int)91));

    public MFXScrollPane() {
        this.initialize();
    }

    public MFXScrollPane(Node content) {
        super(content);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-scroll-pane");
        this.addListeners();
        this.sceneBuilderIntegration();
    }

    public Paint getTrackColor() {
        return (Paint)this.trackColor.get();
    }

    public ObjectProperty<Paint> trackColorProperty() {
        return this.trackColor;
    }

    public void setTrackColor(Paint trackColor) {
        this.trackColor.set((Object)trackColor);
    }

    public Paint getThumbColor() {
        return (Paint)this.thumbColor.get();
    }

    public ObjectProperty<Paint> thumbColorProperty() {
        return this.thumbColor;
    }

    public void setThumbColor(Paint thumbColor) {
        this.thumbColor.set((Object)thumbColor);
    }

    public Paint getThumbHoverColor() {
        return (Paint)this.thumbHoverColor.get();
    }

    public ObjectProperty<Paint> thumbHoverColorProperty() {
        return this.thumbHoverColor;
    }

    public void setThumbHoverColor(Paint thumbHoverColor) {
        this.thumbHoverColor.set((Object)thumbHoverColor);
    }

    private void addListeners() {
        this.trackColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbHoverColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
    }

    private void setColors() {
        StringBuilder sb = new StringBuilder();
        sb.append("-mfx-track-color: ").append(ColorUtils.toCss((Paint)this.trackColor.get())).append(";\n-mfx-thumb-color: ").append(ColorUtils.toCss((Paint)this.thumbColor.get())).append(";\n-mfx-thumb-hover-color: ").append(ColorUtils.toCss((Paint)this.thumbHoverColor.get())).append(";");
        this.setStyle(sb.toString());
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.SCROLL_PANE;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXScrollPaneSkin(this);
    }
}

