/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.functional.BiFunctionProperty;
import io.github.palexdev.materialfx.beans.properties.functional.ConsumerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.controls.models.spinner.SpinnerModel;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.skins.MFXSpinnerSkin;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class MFXSpinner<T>
extends Control
implements Themable {
    private final String STYLE_CLASS = "mfx-spinner";
    private final ReadOnlyObjectWrapper<T> value = new ReadOnlyObjectWrapper();
    private final ObjectProperty<SpinnerModel<T>> spinnerModel = new SimpleObjectProperty();
    private final StringProperty promptText = new SimpleStringProperty("");
    private final BooleanProperty editable = new SimpleBooleanProperty(false);
    private final BooleanProperty selectable = new SimpleBooleanProperty(true);
    private final ConsumerProperty<String> onCommit = new ConsumerProperty();
    private final BiFunctionProperty<Boolean, String, String> textTransformer = new BiFunctionProperty();
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)Orientation.HORIZONTAL);
    private final SupplierProperty<Node> prevIconSupplier = new SupplierProperty();
    private final SupplierProperty<Node> nextIconSupplier = new SupplierProperty();
    private final DoubleProperty graphicTextGap = new SimpleDoubleProperty(10.0);

    public MFXSpinner() {
        this(null);
    }

    public MFXSpinner(SpinnerModel<T> spinnerModel) {
        this.initialize();
        this.setSpinnerModel(spinnerModel);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-spinner");
        this.spinnerModelProperty().addListener((observable, oldValue, newValue) -> {
            this.value.unbind();
            if (newValue != null) {
                this.value.bind(newValue.valueProperty());
            }
        });
        this.defaultIcons();
        this.sceneBuilderIntegration();
    }

    public void defaultIcons() {
        this.setPrevIconSupplier(() -> {
            MFXIconWrapper icon = new MFXIconWrapper("fas-minus", 16.0, -1.0).defaultRippleGeneratorBehavior();
            icon.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                SpinnerModel<T> model = this.getSpinnerModel();
                if (model != null) {
                    model.previous();
                }
            });
            NodeUtils.makeRegionCircular((Region)icon);
            return icon;
        });
        this.setNextIconSupplier(() -> {
            MFXIconWrapper icon = new MFXIconWrapper("fas-plus", 16.0, -1.0).defaultRippleGeneratorBehavior();
            icon.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                SpinnerModel<T> model = this.getSpinnerModel();
                if (model != null) {
                    model.next();
                }
            });
            NodeUtils.makeRegionCircular((Region)icon);
            return icon;
        });
    }

    public void commit(String text) {
        Consumer<String> onCommit = this.getOnCommit();
        if (onCommit != null) {
            onCommit.accept(text);
        }
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.SPINNER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXSpinnerSkin(this);
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public ReadOnlyObjectProperty<T> valueProperty() {
        return this.value.getReadOnlyProperty();
    }

    public void setValue(T value) {
        this.getSpinnerModel().setValue(value);
    }

    public SpinnerModel<T> getSpinnerModel() {
        return (SpinnerModel)this.spinnerModel.get();
    }

    public ObjectProperty<SpinnerModel<T>> spinnerModelProperty() {
        return this.spinnerModel;
    }

    public void setSpinnerModel(SpinnerModel<T> spinnerModel) {
        this.spinnerModel.set(spinnerModel);
    }

    public String getPromptText() {
        return (String)this.promptText.get();
    }

    public StringProperty promptTextProperty() {
        return this.promptText;
    }

    public void setPromptText(String promptText) {
        this.promptText.set((Object)promptText);
    }

    public boolean isEditable() {
        return this.editable.get();
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable.set(editable);
    }

    public boolean isSelectable() {
        return this.selectable.get();
    }

    public BooleanProperty selectableProperty() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable.set(selectable);
    }

    public Consumer<String> getOnCommit() {
        return (Consumer)this.onCommit.get();
    }

    public ConsumerProperty<String> onCommitProperty() {
        return this.onCommit;
    }

    public void setOnCommit(Consumer<String> onCommit) {
        this.onCommit.set(onCommit);
    }

    public BiFunction<Boolean, String, String> getTextTransformer() {
        return (BiFunction)this.textTransformer.get();
    }

    public BiFunctionProperty<Boolean, String, String> textTransformerProperty() {
        return this.textTransformer;
    }

    public void setTextTransformer(BiFunction<Boolean, String, String> textTransformer) {
        this.textTransformer.set(textTransformer);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public Supplier<Node> getPrevIconSupplier() {
        return (Supplier)this.prevIconSupplier.get();
    }

    public SupplierProperty<Node> prevIconSupplierProperty() {
        return this.prevIconSupplier;
    }

    public void setPrevIconSupplier(Supplier<Node> prevIconSupplier) {
        this.prevIconSupplier.set(prevIconSupplier);
    }

    public Supplier<Node> getNextIconSupplier() {
        return (Supplier)this.nextIconSupplier.get();
    }

    public SupplierProperty<Node> nextIconSupplierProperty() {
        return this.nextIconSupplier;
    }

    public void setNextIconSupplier(Supplier<Node> nextIconSupplier) {
        this.nextIconSupplier.set(nextIconSupplier);
    }

    public double getGraphicTextGap() {
        return this.graphicTextGap.get();
    }

    public DoubleProperty graphicTextGapProperty() {
        return this.graphicTextGap;
    }

    public void setGraphicTextGap(double graphicTextGap) {
        this.graphicTextGap.set(graphicTextGap);
    }
}

