/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.functional.ComparatorProperty;
import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.controls.cell.MFXTableRowCell;
import io.github.palexdev.materialfx.enums.SortState;
import io.github.palexdev.materialfx.skins.MFXTableColumnSkin;
import java.util.Comparator;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class MFXTableColumn<T>
extends Labeled {
    private final String STYLE_CLASS = "mfx-table-column";
    private final FunctionProperty<T, MFXTableRowCell<T, ?>> rowCellFactory = new FunctionProperty<T, MFXTableRowCell<T, ?>>(){

        public void set(Function<T, MFXTableRowCell<T, ?>> newValue) {
            super.set(newValue.andThen(cell -> {
                cell.setMinWidth(Double.NEGATIVE_INFINITY);
                cell.prefWidthProperty().bind((ObservableValue)MFXTableColumn.this.widthProperty());
                cell.setMaxWidth(Double.NEGATIVE_INFINITY);
                return cell;
            }));
        }
    };
    private final ObjectProperty<SortState> sortState = new SimpleObjectProperty<SortState>(SortState.UNSORTED){

        public void set(SortState newValue) {
            if (MFXTableColumn.this.getComparator() == null) {
                super.set((Object)SortState.UNSORTED);
                return;
            }
            super.set((Object)newValue);
        }

        protected void invalidated() {
            SortState sortState = MFXTableColumn.this.getSortState();
            Comparator comparator = sortState == SortState.DESCENDING ? MFXTableColumn.this.getComparator().reversed() : MFXTableColumn.this.getComparator();
            MFXTableColumn.this.fireEvent(new MFXTableColumnEvent(MFXTableColumnEvent.SORTING_EVENT, MFXTableColumn.this, comparator, sortState));
        }
    };
    private final ComparatorProperty<T> comparator = new ComparatorProperty<T>(){

        protected void invalidated() {
            SortState sortState = MFXTableColumn.this.getSortState();
            Comparator comparator = sortState == SortState.DESCENDING ? MFXTableColumn.this.getComparator().reversed() : MFXTableColumn.this.getComparator();
            MFXTableColumn.this.fireEvent(new MFXTableColumnEvent(MFXTableColumnEvent.SORTING_EVENT, MFXTableColumn.this, comparator, sortState));
        }
    };
    private final ReadOnlyBooleanWrapper dragged = new ReadOnlyBooleanWrapper();
    private final BooleanProperty columnResizable = new SimpleBooleanProperty(false);
    protected static final PseudoClass DRAGGED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"dragged");
    protected static final PseudoClass RESIZABLE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"resizable");

    public MFXTableColumn() {
        this("");
    }

    public MFXTableColumn(String name) {
        this(name, false);
    }

    public MFXTableColumn(String name, boolean resizable) {
        super(name);
        this.setColumnResizable(resizable);
        this.initialize();
    }

    public MFXTableColumn(String text, Comparator<T> comparator) {
        super(text);
        this.setComparator(comparator);
        this.initialize();
    }

    public MFXTableColumn(String text, boolean resizable, Comparator<T> comparator) {
        super(text);
        this.setColumnResizable(resizable);
        this.setComparator(comparator);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-table-column");
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMinWidth(100.0);
        this.columnResizable.addListener(invalidated -> this.pseudoClassStateChanged(RESIZABLE_PSEUDO_CLASS, this.columnResizable.get()));
        this.pseudoClassStateChanged(RESIZABLE_PSEUDO_CLASS, this.columnResizable.get());
        this.dragged.addListener(invalidated -> this.pseudoClassStateChanged(DRAGGED_PSEUDO_CLASS, this.dragged.get()));
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> this.dragged.set(true));
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> this.dragged.set(false));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (this.getComparator() == null || event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.setSortState(this.getSortState().next());
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXTableColumnSkin(this);
    }

    public Function<T, MFXTableRowCell<T, ?>> getRowCellFactory() {
        return (Function)this.rowCellFactory.get();
    }

    public FunctionProperty<T, MFXTableRowCell<T, ?>> rowCellFactoryProperty() {
        return this.rowCellFactory;
    }

    public void setRowCellFactory(Function<T, MFXTableRowCell<T, ?>> rowCellFactory) {
        this.rowCellFactory.set(rowCellFactory);
    }

    public SortState getSortState() {
        return (SortState)((Object)this.sortState.get());
    }

    public ObjectProperty<SortState> sortStateProperty() {
        return this.sortState;
    }

    public void setSortState(SortState sortState) {
        this.sortState.set((Object)sortState);
    }

    public Comparator<T> getComparator() {
        return (Comparator)this.comparator.get();
    }

    public ComparatorProperty<T> comparatorProperty() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator.set(comparator);
    }

    public boolean isDragged() {
        return this.dragged.get();
    }

    public ReadOnlyBooleanProperty draggedProperty() {
        return this.dragged.getReadOnlyProperty();
    }

    protected void setDragged(boolean dragged) {
        this.dragged.set(dragged);
    }

    public boolean isColumnResizable() {
        return this.columnResizable.get();
    }

    public BooleanProperty columnResizableProperty() {
        return this.columnResizable;
    }

    public void setColumnResizable(boolean columnResizable) {
        this.columnResizable.set(columnResizable);
    }

    public static class MFXTableColumnEvent<T>
    extends Event {
        private final MFXTableColumn<T> column;
        private final Comparator<T> comparator;
        private final SortState sortState;
        public static final EventType<? extends MFXTableColumnEvent> SORTING_EVENT = new EventType(ANY, "SORTING_EVENT");

        public MFXTableColumnEvent(EventType<? extends Event> eventType, MFXTableColumn<T> column, Comparator<T> comparator, SortState sortState) {
            super(eventType);
            this.column = column;
            this.comparator = comparator;
            this.sortState = sortState;
        }

        public MFXTableColumn<T> getColumn() {
            return this.column;
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public SortState getSortState() {
            return this.sortState;
        }
    }
}

