/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.controls.base.MFXLabeled;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.skins.MFXToggleButtonSkin;
import io.github.palexdev.materialfx.utils.ColorUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.utils.ToggleButtonsUtil;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXToggleButton
extends Labeled
implements Toggle,
MFXLabeled,
Themable {
    private static final StyleablePropertyFactory<MFXToggleButton> FACTORY = new StyleablePropertyFactory(Labeled.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-toggle-button";
    private final ObjectProperty<ToggleGroup> toggleGroup = new SimpleObjectProperty();
    private final BooleanProperty selected = new SimpleBooleanProperty(false);
    protected static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private final EventHandlerProperty<ActionEvent> onAction = new EventHandlerProperty<ActionEvent>(){

        protected void invalidated() {
            MFXToggleButton.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }
    };
    private final StyleableObjectProperty<ContentDisplay> contentDisposition = new SimpleStyleableObjectProperty(StyleableProperties.CONTENT_DISPOSITION, (Object)this, "contentDisposition", (Object)ContentDisplay.LEFT);
    private final StyleableDoubleProperty gap = new SimpleStyleableDoubleProperty(StyleableProperties.GAP, (Object)this, "gap", Double.valueOf(8.0));
    private final StyleableDoubleProperty length = new SimpleStyleableDoubleProperty(StyleableProperties.LENGTH, (Object)this, "length", Double.valueOf(36.0));
    private final StyleableDoubleProperty radius = new SimpleStyleableDoubleProperty(StyleableProperties.RADIUS, (Object)this, "radius", Double.valueOf(10.0));
    private final StyleableBooleanProperty textExpand = new SimpleStyleableBooleanProperty(StyleableProperties.TEXT_EXPAND, (Object)this, "textExpand", false);

    public MFXToggleButton() {
        this("");
    }

    public MFXToggleButton(String text) {
        this(text, null);
    }

    public MFXToggleButton(String text, Node graphic) {
        super(text, graphic);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-toggle-button");
        this.setBehavior();
        this.sceneBuilderIntegration();
    }

    protected void setBehavior() {
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.fire());
        this.toggleGroup.addListener((observable, oldTg, newTg) -> {
            if (newTg != null && newTg.getToggles().contains((Object)this)) {
                if (oldTg != null) {
                    oldTg.getToggles().remove((Object)this);
                }
                newTg.getToggles().add((Object)this);
            } else if (newTg == null) {
                oldTg.getToggles().remove((Object)this);
            }
        });
        this.selected.addListener(invalidated -> {
            this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.isSelected());
            ToggleGroup tg = this.getToggleGroup();
            if (tg != null) {
                if (this.isSelected()) {
                    tg.selectToggle((Toggle)this);
                } else if (tg.getSelectedToggle() == this) {
                    ToggleButtonsUtil.clearSelectedToggle(tg);
                }
            }
        });
    }

    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.fireEvent((Event)new ActionEvent());
        }
    }

    public ToggleGroup getToggleGroup() {
        return (ToggleGroup)this.toggleGroup.get();
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return this.toggleGroup;
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroup.set((Object)toggleGroup);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public EventHandlerProperty<ActionEvent> onActionProperty() {
        return this.onAction;
    }

    public void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onAction.set(onAction);
    }

    @Override
    public ContentDisplay getContentDisposition() {
        return (ContentDisplay)this.contentDisposition.get();
    }

    @Override
    public StyleableObjectProperty<ContentDisplay> contentDispositionProperty() {
        return this.contentDisposition;
    }

    @Override
    public void setContentDisposition(ContentDisplay contentDisposition) {
        this.contentDisposition.set((Object)contentDisposition);
    }

    @Override
    public double getGap() {
        return this.gap.get();
    }

    @Override
    public StyleableDoubleProperty gapProperty() {
        return this.gap;
    }

    @Override
    public void setGap(double gap) {
        this.gap.set(gap);
    }

    public double getLength() {
        return this.length.get();
    }

    public StyleableDoubleProperty lengthProperty() {
        return this.length;
    }

    public void setLength(double length) {
        this.length.set(length);
    }

    public double getRadius() {
        return this.radius.get();
    }

    public StyleableDoubleProperty radiusProperty() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius.set(radius);
    }

    @Override
    public boolean isTextExpand() {
        return this.textExpand.get();
    }

    @Override
    public StyleableBooleanProperty textExpandProperty() {
        return this.textExpand;
    }

    @Override
    public void setTextExpand(boolean textExpand) {
        this.textExpand.set(textExpand);
    }

    public void setMainColor(Color color) {
        this.setStyle("-mfx-main: " + ColorUtils.toCss((Paint)color) + ";\n");
    }

    public void setSecondaryColor(Color color) {
        this.setStyle("-mfx-secondary: " + ColorUtils.toCss((Paint)color) + ";\n");
    }

    public void setColors(Color main, Color secondary) {
        this.setStyle("-mfx-main: " + ColorUtils.toCss((Paint)main) + ";\n-mfx-secondary: " + ColorUtils.toCss((Paint)secondary) + ";\n");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.TOGGLE_BUTTON;
    }

    @Override
    public boolean sceneBuilderIntegration() {
        if (Themable.super.sceneBuilderIntegration()) {
            this.setText("Toggle");
            return true;
        }
        return false;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXToggleButtonSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXToggleButton.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXToggleButton, ContentDisplay> CONTENT_DISPOSITION;
        private static final CssMetaData<MFXToggleButton, Number> GAP;
        private static final CssMetaData<MFXToggleButton, Number> LENGTH;
        private static final CssMetaData<MFXToggleButton, Number> RADIUS;
        private static final CssMetaData<MFXToggleButton, Boolean> TEXT_EXPAND;

        private StyleableProperties() {
        }

        static {
            CONTENT_DISPOSITION = FACTORY.createEnumCssMetaData(ContentDisplay.class, "-mfx-content-disposition", MFXToggleButton::contentDispositionProperty, (Enum)ContentDisplay.LEFT);
            GAP = FACTORY.createSizeCssMetaData("-mfx-gap", MFXToggleButton::gapProperty, (Number)8.0);
            LENGTH = FACTORY.createSizeCssMetaData("-mfx-length", MFXToggleButton::lengthProperty, (Number)36.0);
            RADIUS = FACTORY.createSizeCssMetaData("-mfx-radius", MFXToggleButton::radiusProperty, (Number)10.0);
            TEXT_EXPAND = FACTORY.createBooleanCssMetaData("-mfx-text-expand", MFXToggleButton::textExpandProperty, false);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Labeled.getClassCssMetaData(), CONTENT_DISPOSITION, GAP, LENGTH, RADIUS, TEXT_EXPAND);
        }
    }
}

