/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.functional.ConsumerProperty;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.skins.MFXTooltipSkin;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class MFXTooltip
extends MFXPopup {
    private static final WeakHashMap<Node, MFXTooltip> tooltipsMap = new WeakHashMap();
    private final String STYLE_CLASS = "mfx-tooltip";
    private final ObjectProperty<Node> icon = new SimpleObjectProperty();
    private final StringProperty text = new SimpleStringProperty();
    private Node owner;
    private final PositionBean mousePosition = PositionBean.of(0.0, 0.0);
    private final ConsumerProperty<PositionBean> showAction = new ConsumerProperty<PositionBean>(position -> this.show(this.owner, position.getX(), position.getY()));
    private EventHandler<MouseEvent> mouseTracker;
    private EventHandler<MouseEvent> mouseEntered;
    private EventHandler<MouseEvent> mouseExited;
    private EventHandler<MouseEvent> mousePressed;
    private PauseTransition delayAnimation;
    private PauseTransition hideAnimation;
    private Duration showDelay = Duration.seconds((double)1.0);
    private Duration hideAfter = Duration.seconds((double)30.0);

    public MFXTooltip(Node owner) {
        this(owner, "");
    }

    public MFXTooltip(Node owner, String text) {
        if (owner == null) {
            throw new NullPointerException("Owner node cannot be null!");
        }
        if (tooltipsMap.getOrDefault(owner, null) != null) {
            throw new IllegalArgumentException("A tooltip for the given node already exists!");
        }
        this.owner = owner;
        this.setText(text);
        this.hideAnimation = AnimationUtils.PauseBuilder.build().setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.hide())).getAnimation();
        this.delayAnimation = AnimationUtils.PauseBuilder.build().setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
            Control control;
            if (owner instanceof Control && (control = (Control)owner).getTooltip() != null) {
                throw new IllegalStateException("The given control already has a JavaFX Tooltip installed!");
            }
            this.getShowAction().accept(this.mousePosition);
            if (this.hideAfter == Duration.INDEFINITE) {
                return;
            }
            this.hideAnimation.setDuration(this.hideAfter);
            this.hideAnimation.playFromStart();
        })).getAnimation();
        this.mouseTracker = event -> {
            this.mousePosition.setX(event.getScreenX() + 10.0);
            this.mousePosition.setY(event.getScreenY() + 10.0);
        };
        this.mouseEntered = event -> {
            if (this.isShowing() || AnimationUtils.isPlaying((Animation)this.delayAnimation)) {
                this.hideAnimation.stop();
                return;
            }
            this.hideAnimation.stop();
            this.delayAnimation.setDuration(this.showDelay);
            this.delayAnimation.playFromStart();
        };
        this.mouseExited = event -> {
            if (AnimationUtils.isPlaying((Animation)this.hideAnimation)) {
                this.hideAnimation.stop();
            }
            if (AnimationUtils.isPlaying((Animation)this.delayAnimation)) {
                this.delayAnimation.stop();
            }
            this.hide();
        };
        this.mousePressed = event -> {
            if (AnimationUtils.isPlaying((Animation)this.hideAnimation)) {
                this.hideAnimation.stop();
            }
            if (AnimationUtils.isPlaying((Animation)this.delayAnimation)) {
                this.delayAnimation.stop();
            }
            this.hide();
        };
        this.initialize();
    }

    public static MFXTooltip of(Node owner, String text) {
        return new MFXTooltip(owner, text);
    }

    public static void disposeFor(Node node) {
        MFXTooltip tooltip = tooltipsMap.remove(node);
        if (tooltip != null) {
            tooltip.dispose();
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-tooltip");
    }

    public MFXTooltip install() {
        this.owner.addEventFilter(MouseEvent.MOUSE_MOVED, this.mouseTracker);
        this.owner.addEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.owner.addEventFilter(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.owner.addEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
        return this;
    }

    public void uninstall() {
        this.owner.removeEventFilter(MouseEvent.MOUSE_MOVED, this.mouseTracker);
        this.owner.removeEventFilter(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.owner.removeEventFilter(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.owner.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
    }

    public void dispose() {
        if (this.owner != null) {
            this.uninstall();
            this.mouseTracker = null;
            this.mouseEntered = null;
            this.mouseExited = null;
            this.mousePressed = null;
            this.delayAnimation = null;
            this.hideAnimation = null;
            tooltipsMap.remove(this.owner);
            this.owner = null;
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXTooltipSkin(this);
    }

    public Node getOwner() {
        return this.owner;
    }

    public PositionBean getMousePosition() {
        return this.mousePosition;
    }

    public Consumer<PositionBean> getShowAction() {
        return (Consumer)this.showAction.get();
    }

    public ConsumerProperty<PositionBean> showActionProperty() {
        return this.showAction;
    }

    public void setShowAction(Consumer<PositionBean> showAction) {
        this.showAction.set(showAction);
    }

    public Node getIcon() {
        return (Node)this.icon.get();
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public void setIcon(Node icon) {
        this.icon.set((Object)icon);
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public Duration getShowDelay() {
        return this.showDelay;
    }

    public void setShowDelay(Duration showDelay) {
        this.showDelay = showDelay;
    }

    public Duration getHideAfter() {
        return this.hideAfter;
    }

    public void setHideAfter(Duration hideAfter) {
        this.hideAfter = hideAfter;
    }
}

