/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeCell;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.controls.cell.MFXSimpleTreeCell;
import io.github.palexdev.materialfx.css.themes.Stylesheets;
import io.github.palexdev.materialfx.css.themes.Theme;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.selection.base.ITreeSelectionModel;
import io.github.palexdev.materialfx.skins.MFXTreeItemSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class MFXTreeItem<T>
extends AbstractMFXTreeItem<T> {
    private static final StyleablePropertyFactory<MFXTreeItem<?>> FACTORY = new StyleablePropertyFactory(MFXTreeItem.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-tree-item";
    private final BooleanProperty expanded = new SimpleBooleanProperty(false);
    private final ReadOnlyBooleanWrapper animationRunning = new ReadOnlyBooleanWrapper(false);
    private final ReadOnlyDoubleWrapper initialHeight = new ReadOnlyDoubleWrapper(0.0);
    private final StyleableDoubleProperty animationDuration = new SimpleStyleableDoubleProperty(StyleableProperties.DURATION, (Object)this, "animationDuration", Double.valueOf(250.0));

    public MFXTreeItem(T data) {
        super(data);
        this.defaultCellFactory();
        this.initialize();
    }

    public MFXTreeItem(T data, Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>> cellFactory) {
        super(data);
        this.setCellFactory(cellFactory);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-tree-item");
        this.items.addListener(change -> {
            ArrayList tmpRemoved = new ArrayList();
            ArrayList tmpAdded = new ArrayList();
            while (change.next()) {
                tmpRemoved.addAll(change.getRemoved());
                tmpAdded.addAll(change.getAddedSubList());
            }
            this.updateChildrenParent(tmpRemoved, null);
            this.updateChildrenParent(tmpAdded, this);
        });
        this.treeViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && this.isRoot()) {
                newValue.getSelectionModel().scanTree(this.getRoot());
            }
        });
        this.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.getSelectionModel() != null) {
                this.getSelectionModel().scanTree(this);
            }
        });
        this.childrenMarginProperty().addListener((observable, oldValue, newValue) -> this.requestLayout());
    }

    public boolean isExpanded() {
        return this.expanded.get();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public double getInitialHeight() {
        return this.initialHeight.get();
    }

    public ReadOnlyDoubleProperty initialHeightProperty() {
        return this.initialHeight;
    }

    public void setInitialHeight(double height) {
        this.initialHeight.set(height);
    }

    public boolean isAnimationRunning() {
        return this.animationRunning.get();
    }

    public ReadOnlyBooleanWrapper animationRunningProperty() {
        return this.animationRunning;
    }

    public double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public StyleableDoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDuration) {
        this.animationDuration.set(animationDuration);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public ITreeSelectionModel<T> getSelectionModel() {
        if (this.getTreeView() != null) {
            return this.getTreeView().getSelectionModel();
        }
        return null;
    }

    @Override
    protected void defaultCellFactory() {
        this.cellFactory.set(MFXSimpleTreeCell::new);
    }

    @Override
    protected void updateChildrenParent(List<? extends AbstractMFXTreeItem<T>> treeItems, AbstractMFXTreeItem<T> newParent) {
        treeItems.forEach(item -> item.setItemParent(newParent));
    }

    @Override
    public Theme getTheme() {
        return Stylesheets.TREE_ITEM;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXTreeItemSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXTreeItem.getControlCssMetaDataList();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.items.forEach(item -> VBox.setMargin((Node)item, (Insets)InsetsFactory.right(this.getChildrenMargin())));
    }

    public String toString() {
        String className = this.getClass().getName();
        String simpleName = className.substring(className.lastIndexOf(46) + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(simpleName);
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("]");
        sb.append("[Data:").append(this.getData()).append("]");
        if (this.getId() != null) {
            sb.append("[id:").append(this.getId()).append("]");
        }
        return sb.toString();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXTreeItem<?>, Number> DURATION;

        private StyleableProperties() {
        }

        static {
            DURATION = FACTORY.createSizeCssMetaData("-mfx-animation-duration", MFXTreeItem::animationDurationProperty, (Number)250.0);
            cssMetaDataList = List.of(DURATION);
        }
    }

    public static class TreeItemEvent<T>
    extends Event {
        private final WeakReference<AbstractMFXTreeItem<T>> itemRef;
        private final double value;
        public static final EventType<TreeItemEvent<?>> ADD_REMOVE_ITEM_EVENT = new EventType(ANY, "ADD_ITEM_EVENT");
        public static final EventType<TreeItemEvent<?>> EXPAND_EVENT = new EventType(ANY, "EXPAND_EVENT");
        public static final EventType<TreeItemEvent<?>> COLLAPSE_EVENT = new EventType(ANY, "COLLAPSE_EVENT");

        public TreeItemEvent(EventType<? extends Event> eventType, AbstractMFXTreeItem<T> item, double value) {
            super(eventType);
            this.itemRef = new WeakReference<AbstractMFXTreeItem<AbstractMFXTreeItem<T>>>(item);
            this.value = value;
        }

        public AbstractMFXTreeItem<T> getItem() {
            return (AbstractMFXTreeItem)this.itemRef.get();
        }

        public double getValue() {
            return this.value;
        }
    }
}

