/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.base;

import io.github.palexdev.materialfx.controls.MFXTreeView;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeCell;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.selection.base.ITreeSelectionModel;
import io.github.palexdev.materialfx.utils.TreeItemStream;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.util.Callback;

public abstract class AbstractMFXTreeItem<T>
extends Control
implements Themable {
    protected final T data;
    protected final ObservableList<AbstractMFXTreeItem<T>> items = FXCollections.observableArrayList();
    protected AbstractMFXTreeItem<T> parent;
    private final ObjectProperty<MFXTreeView<T>> treeView = new SimpleObjectProperty(null);
    protected final ObjectProperty<Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>>> cellFactory = new SimpleObjectProperty();
    private final DoubleProperty childrenMargin = new SimpleDoubleProperty(20.0);
    private final BooleanProperty startExpanded = new SimpleBooleanProperty(false);
    private final BooleanProperty selected = new SimpleBooleanProperty(false);

    public AbstractMFXTreeItem(T data) {
        this.data = data;
        this.sceneBuilderIntegration();
    }

    public abstract ITreeSelectionModel<T> getSelectionModel();

    protected abstract void defaultCellFactory();

    protected abstract void updateChildrenParent(List<? extends AbstractMFXTreeItem<T>> var1, AbstractMFXTreeItem<T> var2);

    public boolean isRoot() {
        return this.parent == null;
    }

    public AbstractMFXTreeItem<T> getRoot() {
        if (this.isRoot()) {
            return this;
        }
        AbstractMFXTreeItem<T> par = this;
        while (!(par = par.getItemParent()).isRoot()) {
        }
        return par;
    }

    public long getIndex() {
        if (this.isRoot()) {
            return 0L;
        }
        return TreeItemStream.flattenTree(this.getRoot()).takeWhile(item -> !item.equals(this)).count();
    }

    public long getItemsCount() {
        return TreeItemStream.stream(this).count();
    }

    public int getLevel() {
        if (this.isRoot()) {
            return 0;
        }
        int index = 0;
        AbstractMFXTreeItem<T> par = this;
        do {
            par = par.getItemParent();
            ++index;
        } while (!par.isRoot());
        return index;
    }

    public AbstractMFXTreeItem<T> getNextSibling() {
        if (this.isRoot()) {
            return null;
        }
        ObservableList<AbstractMFXTreeItem<T>> parentItems = this.getItemParent().getItems();
        int index = parentItems.indexOf(this);
        if (index == parentItems.size() - 1) {
            return null;
        }
        return (AbstractMFXTreeItem)parentItems.get(index + 1);
    }

    public AbstractMFXTreeItem<T> getPreviousSibling() {
        if (this.isRoot()) {
            return null;
        }
        ObservableList<AbstractMFXTreeItem<T>> parentItems = this.getItemParent().getItems();
        int index = parentItems.indexOf(this);
        if (index == 0) {
            return null;
        }
        return (AbstractMFXTreeItem)parentItems.get(index - 1);
    }

    public boolean isLeaf() {
        return this.items.isEmpty();
    }

    public MFXTreeView<T> getTreeView() {
        if (this.isRoot()) {
            return (MFXTreeView)this.treeView.get();
        }
        return this.getRoot().getTreeView();
    }

    public ObjectProperty<MFXTreeView<T>> treeViewProperty() {
        return this.treeView;
    }

    public void setTreeView(MFXTreeView<T> treeView) {
        this.treeView.set(treeView);
    }

    public T getData() {
        return this.data;
    }

    public ObservableList<AbstractMFXTreeItem<T>> getItems() {
        return this.items;
    }

    public void setItems(ObservableList<AbstractMFXTreeItem<T>> items) {
        this.items.setAll(items);
    }

    public AbstractMFXTreeItem<T> getItemParent() {
        return this.parent;
    }

    public void setItemParent(AbstractMFXTreeItem<T> parent) {
        this.parent = parent;
    }

    public double getChildrenMargin() {
        return this.childrenMargin.get();
    }

    public DoubleProperty childrenMarginProperty() {
        return this.childrenMargin;
    }

    public void setChildrenMargin(double childrenMargin) {
        this.childrenMargin.set(childrenMargin);
    }

    public boolean isStartExpanded() {
        return this.startExpanded.get();
    }

    public BooleanProperty startExpandedProperty() {
        return this.startExpanded;
    }

    public void setStartExpanded(boolean startExpanded) {
        this.startExpanded.set(startExpanded);
    }

    public Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public ObjectProperty<Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    @Override
    public Parent toParent() {
        return this;
    }
}

