/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.legacy;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXLegacyListCell<T>
extends ListCell<T> {
    private static final StyleablePropertyFactory<MFXLegacyListCell<?>> FACTORY = new StyleablePropertyFactory(ListCell.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-legacy-list-cell";
    private final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final StyleableObjectProperty<Paint> selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.SELECTED_COLOR, (Object)this, "selectedColor", (Object)Color.rgb((int)180, (int)180, (int)255));
    private final StyleableObjectProperty<Paint> hoverColor = new SimpleStyleableObjectProperty(StyleableProperties.HOVER_COLOR, (Object)this, "hoverColor", (Object)Color.rgb((int)50, (int)150, (int)255, (double)0.2));
    private final StyleableDoubleProperty cornerRadius = new SimpleStyleableDoubleProperty(StyleableProperties.CORNER_RADIUS, (Object)this, "cornerRadius", Double.valueOf(0.0));
    private final StyleableDoubleProperty backgroundInsets = new SimpleStyleableDoubleProperty(StyleableProperties.BACKGROUND_INSETS, (Object)this, "backgroundInsets", Double.valueOf(0.0));

    public MFXLegacyListCell() {
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-legacy-list-cell");
        this.setPadding(InsetsFactory.of(8.0, 12.0, 8.0, 12.0));
        this.addListeners();
    }

    private void addListeners() {
        this.listViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)newValue.widthProperty().divide(2.0));
            }
        });
        this.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                NodeUtils.updateBackground((Region)this, this.getSelectedColor(), new CornerRadii(this.getCornerRadius()), InsetsFactory.all(this.getBackgroundInsets()));
            } else {
                NodeUtils.updateBackground((Region)this, (Paint)Color.WHITE, new CornerRadii(this.getCornerRadius()), InsetsFactory.all(this.getBackgroundInsets()));
            }
        });
        this.backgroundProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && this.isSelected() && !this.containsFill(newValue.getFills(), this.getSelectedColor())) {
                NodeUtils.updateBackground((Region)this, this.getSelectedColor(), new CornerRadii(this.getCornerRadius()), InsetsFactory.all(this.getBackgroundInsets()));
            }
        });
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (this.isSelected() || this.isEmpty()) {
                return;
            }
            if (newValue.booleanValue()) {
                if (this.getIndex() == 0) {
                    this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.getHoverColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
                } else {
                    NodeUtils.updateBackground((Region)this, this.getHoverColor(), new CornerRadii(this.getCornerRadius()), InsetsFactory.all(this.getBackgroundInsets()));
                }
            } else {
                NodeUtils.updateBackground((Region)this, (Paint)Color.WHITE, new CornerRadii(this.getCornerRadius()), InsetsFactory.all(this.getBackgroundInsets()));
            }
        });
        this.selectedColor.addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.equals(oldValue) && this.isSelected()) {
                NodeUtils.updateBackground((Region)this, newValue);
            }
        });
        this.setupRippleGenerator();
    }

    protected void setupRippleGenerator() {
        this.rippleGenerator.setRippleColor((Paint)Color.rgb((int)50, (int)150, (int)255));
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this.rippleGenerator::generateRipple);
    }

    private boolean containsFill(List<BackgroundFill> backgroundFills, Paint fill) {
        List paints = backgroundFills.stream().map(BackgroundFill::getFill).collect(Collectors.toList());
        return paints.contains(fill);
    }

    public Paint getSelectedColor() {
        return (Paint)this.selectedColor.get();
    }

    public StyleableObjectProperty<Paint> selectedColorProperty() {
        return this.selectedColor;
    }

    public void setSelectedColor(Paint selectedColor) {
        this.selectedColor.set((Object)selectedColor);
    }

    public Paint getHoverColor() {
        return (Paint)this.hoverColor.get();
    }

    public StyleableObjectProperty<Paint> hoverColorProperty() {
        return this.hoverColor;
    }

    public void setHoverColor(Paint hoverColor) {
        this.hoverColor.set((Object)hoverColor);
    }

    public double getCornerRadius() {
        return this.cornerRadius.get();
    }

    public StyleableDoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public void setCornerRadius(double cornerRadius) {
        this.cornerRadius.set(cornerRadius);
    }

    public double getBackgroundInsets() {
        return this.backgroundInsets.get();
    }

    public StyleableDoubleProperty backgroundInsetsProperty() {
        return this.backgroundInsets;
    }

    public void setBackgroundInsets(double backgroundInsets) {
        this.backgroundInsets.set(backgroundInsets);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXLegacyListCell.getControlCssMetaDataList();
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            if (item instanceof Node) {
                Node nodeItem = (Node)item;
                this.setGraphic(nodeItem);
            } else {
                this.setText(item.toString());
            }
            if (!this.getChildren().contains((Object)this.rippleGenerator)) {
                this.getChildren().add(0, (Object)this.rippleGenerator);
            }
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXLegacyListCell<?>, Paint> SELECTED_COLOR;
        private static final CssMetaData<MFXLegacyListCell<?>, Paint> HOVER_COLOR;
        private static final CssMetaData<MFXLegacyListCell<?>, Number> CORNER_RADIUS;
        private static final CssMetaData<MFXLegacyListCell<?>, Number> BACKGROUND_INSETS;

        private StyleableProperties() {
        }

        static {
            SELECTED_COLOR = FACTORY.createPaintCssMetaData("-mfx-selected-color", MFXLegacyListCell::selectedColorProperty, (Paint)Color.rgb((int)180, (int)180, (int)255));
            HOVER_COLOR = FACTORY.createPaintCssMetaData("-mfx-hover-color", MFXLegacyListCell::hoverColorProperty, (Paint)Color.rgb((int)50, (int)150, (int)255, (double)0.2));
            CORNER_RADIUS = FACTORY.createSizeCssMetaData("-mfx-corner-radius", MFXLegacyListCell::cornerRadiusProperty, (Number)0);
            BACKGROUND_INSETS = FACTORY.createSizeCssMetaData("-mfx-background-insets", MFXLegacyListCell::backgroundInsetsProperty, (Number)0);
            ArrayList licCssMetaData = new ArrayList(ListCell.getClassCssMetaData());
            Collections.addAll(licCssMetaData, SELECTED_COLOR, HOVER_COLOR, CORNER_RADIUS, BACKGROUND_INSETS);
            cssMetaDataList = Collections.unmodifiableList(licCssMetaData);
        }
    }
}

