/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.legacy;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Insets;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXLegacyTableRow<T>
extends TableRow<T> {
    private static final StyleablePropertyFactory<MFXLegacyTableRow<?>> FACTORY = new StyleablePropertyFactory(TableRow.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-legacy-table-row";
    private final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final StyleableObjectProperty<Paint> selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.SELECTED_COLOR, (Object)this, "selectedColor", (Object)Color.rgb((int)180, (int)180, (int)255));
    private final StyleableObjectProperty<Paint> hoverColor = new SimpleStyleableObjectProperty(StyleableProperties.HOVER_COLOR, (Object)this, "hoverColor", (Object)Color.rgb((int)50, (int)150, (int)255, (double)0.15));

    public MFXLegacyTableRow() {
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-legacy-table-row");
        this.setupRippleGenerator();
        this.addListeners();
    }

    private void setupRippleGenerator() {
        this.rippleGenerator.setRippleColor((Paint)Color.rgb((int)50, (int)150, (int)255));
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this.rippleGenerator::generateRipple);
    }

    private void addListeners() {
        this.tableViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)newValue.widthProperty().divide(2.0));
            }
        });
        this.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                NodeUtils.updateBackground((Region)this, this.getSelectedColor());
            } else {
                NodeUtils.updateBackground((Region)this, (Paint)Color.WHITE);
            }
        });
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (this.isSelected() || this.isEmpty()) {
                return;
            }
            if (newValue.booleanValue()) {
                if (this.getIndex() == 0) {
                    this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.getHoverColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
                } else {
                    NodeUtils.updateBackground((Region)this, this.getHoverColor());
                }
            } else {
                NodeUtils.updateBackground((Region)this, (Paint)Color.WHITE);
            }
        });
        this.selectedColor.addListener((observableValue, oldValue, newValue) -> {
            if (!newValue.equals(oldValue) && this.isSelected()) {
                NodeUtils.updateBackground((Region)this, newValue);
            }
        });
    }

    public Paint getSelectedColor() {
        return (Paint)this.selectedColor.get();
    }

    public StyleableObjectProperty<Paint> selectedColorProperty() {
        return this.selectedColor;
    }

    public void setSelectedColor(Paint selectedColor) {
        this.selectedColor.set((Object)selectedColor);
    }

    public Paint getHoverColor() {
        return (Paint)this.hoverColor.get();
    }

    public StyleableObjectProperty<Paint> hoverColorProperty() {
        return this.hoverColor;
    }

    public void setHoverColor(Paint hoverColor) {
        this.hoverColor.set((Object)hoverColor);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXLegacyTableRow.getControlCssMetaDataList();
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!this.getChildren().contains((Object)this.rippleGenerator)) {
            this.getChildren().add(0, (Object)this.rippleGenerator);
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXLegacyTableRow<?>, Paint> SELECTED_COLOR;
        private static final CssMetaData<MFXLegacyTableRow<?>, Paint> HOVER_COLOR;

        private StyleableProperties() {
        }

        static {
            SELECTED_COLOR = FACTORY.createPaintCssMetaData("-mfx-selected-color", MFXLegacyTableRow::selectedColorProperty, (Paint)Color.rgb((int)180, (int)180, (int)255));
            HOVER_COLOR = FACTORY.createPaintCssMetaData("-mfx-hover-color", MFXLegacyTableRow::hoverColorProperty, (Paint)Color.rgb((int)50, (int)150, (int)255, (double)0.15));
            ArrayList tarCssMetaData = new ArrayList(TableRow.getClassCssMetaData());
            Collections.addAll(tarCssMetaData, SELECTED_COLOR, HOVER_COLOR);
            cssMetaDataList = Collections.unmodifiableList(tarCssMetaData);
        }
    }
}

