/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.models.spinner;

import io.github.palexdev.materialfx.controls.models.spinner.AbstractSpinnerModel;
import io.github.palexdev.materialfx.utils.others.dates.DateStringConverter;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAmount;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;

public class LocalDateSpinnerModel
extends AbstractSpinnerModel<LocalDate> {
    private final ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> min = new SimpleObjectProperty();
    private final ObjectProperty<LocalDate> max = new SimpleObjectProperty();
    private final ObjectProperty<TemporalAmount> increment = new SimpleObjectProperty();

    public LocalDateSpinnerModel() {
        this(LocalDate.EPOCH);
    }

    public LocalDateSpinnerModel(LocalDate initialValue) {
        this.setConverter(new DateStringConverter(FormatStyle.MEDIUM));
        this.setDefaultValue(LocalDate.EPOCH);
        this.setMin(LocalDate.EPOCH);
        this.setMax(LocalDate.MAX);
        this.setIncrement(Duration.ofDays(1L));
        this.setValue(initialValue);
    }

    @Override
    public void next() {
        LocalDate next = ((LocalDate)this.getValue()).plus(this.getIncrement());
        if (next.isAfter(this.getMax())) {
            next = this.isWrapAround() ? this.getMin() : this.getMax();
        }
        this.setValue(next);
    }

    @Override
    public void previous() {
        LocalDate prev = ((LocalDate)this.getValue()).minus(this.getIncrement());
        if (prev.isBefore(this.getMin())) {
            prev = this.isWrapAround() ? this.getMax() : this.getMin();
        }
        this.setValue(prev);
    }

    @Override
    public StringConverter<LocalDate> getConverter() {
        return (StringConverter)this.converter.get();
    }

    @Override
    public ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    @Override
    public void setConverter(StringConverter<LocalDate> converter) {
        this.converter.set(converter);
    }

    public LocalDate getMin() {
        return (LocalDate)this.min.get();
    }

    public ObjectProperty<LocalDate> minProperty() {
        return this.min;
    }

    public void setMin(LocalDate min) {
        this.min.set((Object)min);
    }

    public LocalDate getMax() {
        return (LocalDate)this.max.get();
    }

    public ObjectProperty<LocalDate> maxProperty() {
        return this.max;
    }

    public void setMax(LocalDate max) {
        this.max.set((Object)max);
    }

    public TemporalAmount getIncrement() {
        return (TemporalAmount)this.increment.get();
    }

    public ObjectProperty<TemporalAmount> incrementProperty() {
        return this.increment;
    }

    public void setIncrement(TemporalAmount increment) {
        this.increment.set((Object)increment);
    }
}

