/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.css.themes;

import java.util.HashMap;
import java.util.Map;

public interface Theme {
    public String getTheme();

    public String loadTheme();

    default public String mfxBaseDir() {
        return "css/";
    }

    public static class Helper {
        private static final Map<Theme, String> CACHE = new HashMap<Theme, String>();

        public static boolean isCached(Theme theme) {
            return CACHE.containsKey(theme);
        }

        public static String cacheTheme(Theme theme) {
            String loaded = theme.loadTheme();
            if (loaded == null) {
                return "";
            }
            CACHE.put(theme, loaded);
            return loaded;
        }

        protected static String cacheTheme(Theme theme, String loaded) {
            CACHE.put(theme, loaded);
            return loaded;
        }

        public static String getCachedTheme(Theme theme) {
            return CACHE.get(theme);
        }
    }
}

