/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class DoubleFilter<T>
extends NumberFilter<T, Double> {
    public DoubleFilter(String name, Function<T, Double> extractor) {
        this(name, extractor, (StringConverter<Double>)new DoubleStringConverter());
    }

    public DoubleFilter(String name, Function<T, Double> extractor, StringConverter<Double> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<Double, Double>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.is", new Object[0]), Double::equals), new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.isNot", new Object[0]), (aDouble, aDouble2) -> !aDouble.equals(aDouble2)), new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.greater", new Object[0]), (aDouble, aDouble2) -> aDouble > aDouble2), new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.greaterEqual", new Object[0]), (aDouble, aDouble2) -> aDouble >= aDouble2), new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.lesser", new Object[0]), (aDouble, aDouble2) -> aDouble < aDouble2), new BiPredicateBean<Double, Double>(I18N.getOrDefault("filter.lesserEqual", new Object[0]), (aDouble, aDouble2) -> aDouble <= aDouble2)).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final DoubleFilter<T> extend(BiPredicateBean<Double, Double> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

