/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class IntegerFilter<T>
extends NumberFilter<T, Integer> {
    public IntegerFilter(String name, Function<T, Integer> extractor) {
        this(name, extractor, (StringConverter<Integer>)new IntegerStringConverter());
    }

    public IntegerFilter(String name, Function<T, Integer> extractor, StringConverter<Integer> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<Integer, Integer>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.is", new Object[0]), Integer::equals), new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.isNot", new Object[0]), (anInteger, anInteger2) -> !anInteger.equals(anInteger2)), new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.greater", new Object[0]), (anInteger, anInteger2) -> anInteger > anInteger2), new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.greaterEqual", new Object[0]), (anInteger, anInteger2) -> anInteger >= anInteger2), new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.lesser", new Object[0]), (anInteger, anInteger2) -> anInteger < anInteger2), new BiPredicateBean<Integer, Integer>(I18N.getOrDefault("filter.lesserEqual", new Object[0]), (anInteger, anInteger2) -> anInteger <= anInteger2)).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final IntegerFilter<T> extend(BiPredicateBean<Integer, Integer> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

