/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javafx.util.converter.LongStringConverter;

public class LongFilter<T>
extends NumberFilter<T, Long> {
    public LongFilter(String name, Function<T, Long> extractor) {
        this(name, extractor, (StringConverter<Long>)new LongStringConverter());
    }

    public LongFilter(String name, Function<T, Long> extractor, StringConverter<Long> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<Long, Long>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.is", new Object[0]), Long::equals), new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.isNot", new Object[0]), (aLong, aLong2) -> !aLong.equals(aLong2)), new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.greater", new Object[0]), (aLong, aLong2) -> aLong > aLong2), new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.greaterEqual", new Object[0]), (aLong, aLong2) -> aLong >= aLong2), new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.lesser", new Object[0]), (aLong, aLong2) -> aLong < aLong2), new BiPredicateBean<Long, Long>(I18N.getOrDefault("filter.lesserEqual", new Object[0]), (aLong, aLong2) -> aLong <= aLong2)).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final LongFilter<T> extend(BiPredicateBean<Long, Long> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

